/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.client.WidgetDataWhiteList;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.StylesUtil;
import org.eclipse.rap.rwt.internal.util.EncodingUtil;
import org.eclipse.rap.rwt.internal.util.MnemonicUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public final class WidgetLCAUtil {
    private static final String PARAM_X = "bounds.x";
    private static final String PARAM_Y = "bounds.y";
    private static final String PARAM_WIDTH = "bounds.width";
    private static final String PARAM_HEIGHT = "bounds.height";
    private static final String PROP_TOOL_TIP = "toolTip";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_TRANSPARENCY = "backgroundTrans";
    private static final String PROP_BACKGROUND_GRADIENT_COLORS = "backgroundGradientColors";
    private static final String PROP_BACKGROUND_GRADIENT_PERCENTS = "backgroundGradientPercents";
    private static final String PROP_BACKGROUND_GRADIENT_VERTICAL = "backgroundGradientVertical";
    private static final String PROP_ROUNDED_BORDER_WIDTH = "roundedBorderWidth";
    private static final String PROP_ROUNDED_BORDER_COLOR = "roundedBorderColor";
    private static final String PROP_ROUNDED_BORDER_RADIUS = "roundedBorderRadius";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_VARIANT = "variant";
    private static final String PROP_DATA = "data";
    private static final String PROP_HELP_LISTENER = "Help";
    static final String LISTENER_PREFIX = "listener_";
    private static final Rectangle DEF_ROUNDED_BORDER_RADIUS = new Rectangle(0, 0, 0, 0);

    private WidgetLCAUtil() {
    }

    public static Rectangle readBounds(Widget widget, Rectangle defaultValue) {
        return WidgetLCAUtil.readBounds(WidgetUtil.getId(widget), defaultValue);
    }

    public static Rectangle readBounds(String widgetId, Rectangle defaultValue) {
        int x = WidgetLCAUtil.readBoundsX(widgetId, defaultValue.x);
        int y = WidgetLCAUtil.readBoundsY(widgetId, defaultValue.y);
        int width = WidgetLCAUtil.readBoundsWidth(widgetId, defaultValue.width);
        int height = WidgetLCAUtil.readBoundsHeight(widgetId, defaultValue.height);
        return new Rectangle(x, y, width, height);
    }

    private static int readBoundsY(String widgetId, int defaultValue) {
        String value = ProtocolUtil.readPropertyValueAsString(widgetId, PARAM_Y);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsX(String widgetId, int defaultValue) {
        String value = ProtocolUtil.readPropertyValueAsString(widgetId, PARAM_X);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsWidth(String widgetId, int defaultValue) {
        String value = ProtocolUtil.readPropertyValueAsString(widgetId, PARAM_WIDTH);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsHeight(String widgetId, int defaultValue) {
        String value = ProtocolUtil.readPropertyValueAsString(widgetId, PARAM_HEIGHT);
        return WidgetLCAUtil.readBoundsValue(value, defaultValue);
    }

    private static int readBoundsValue(String value, int current) {
        int result = value != null && !"null".equals(value) ? NumberFormatUtil.parseInt(value) : current;
        return result;
    }

    public static void processHelp(Widget widget) {
        if (WidgetLCAUtil.wasEventSent(widget, PROP_HELP_LISTENER)) {
            widget.notifyListeners(28, new Event());
        }
    }

    public static void preserveBounds(Widget widget, Rectangle bounds) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve("bounds", bounds);
    }

    public static void preserveEnabled(Widget widget, boolean enabled) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_ENABLED, enabled);
    }

    public static void preserveToolTipText(Widget widget, String toolTip) {
        String text = toolTip == null ? "" : toolTip;
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_TOOL_TIP, text);
    }

    public static void preserveFont(Widget widget, Font font) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_FONT, font);
    }

    public static void preserveForeground(Widget widget, Color foreground) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_FOREGROUND, foreground);
    }

    public static void preserveBackground(Widget widget, Color background) {
        WidgetLCAUtil.preserveBackground(widget, background, false);
    }

    public static void preserveBackground(Widget widget, Color background, boolean transparency) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_BACKGROUND, background);
        adapter.preserve(PROP_BACKGROUND_TRANSPARENCY, transparency);
    }

    public static void preserveBackgroundGradient(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
            int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
            boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
            WidgetAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents);
            widgetAdapter.preserve(PROP_BACKGROUND_GRADIENT_VERTICAL, bgGradientVertical);
        }
    }

    public static void preserveRoundedBorder(Widget widget) {
        IWidgetGraphicsAdapter adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        if (adapter != null) {
            IWidgetGraphicsAdapter gfxAdapter = adapter;
            int width = gfxAdapter.getRoundedBorderWidth();
            Color color = gfxAdapter.getRoundedBorderColor();
            Rectangle radius = gfxAdapter.getRoundedBorderRadius();
            WidgetAdapter widgetAdapter = WidgetUtil.getAdapter(widget);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_WIDTH, width);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_COLOR, color);
            widgetAdapter.preserve(PROP_ROUNDED_BORDER_RADIUS, radius);
        }
    }

    public static void preserveCustomVariant(Widget widget) {
        String variant = WidgetUtil.getVariant(widget);
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(PROP_VARIANT, variant);
    }

    public static void preserveData(Widget widget) {
        WidgetLCAUtil.preserveProperty(widget, PROP_DATA, WidgetLCAUtil.getDataAsArray(widget));
    }

    public static void preserveHelpListener(Widget widget) {
        WidgetLCAUtil.preserveListener(widget, PROP_HELP_LISTENER, EventLCAUtil.isListening(widget, 28));
    }

    public static void renderBounds(Widget widget, Rectangle bounds) {
        WidgetLCAUtil.renderProperty(widget, "bounds", bounds, null);
    }

    public static void renderEnabled(Widget widget, boolean enabled) {
        WidgetLCAUtil.renderProperty(widget, PROP_ENABLED, enabled, true);
    }

    public static void renderCustomVariant(Widget widget) {
        String newValue = WidgetUtil.getVariant(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_VARIANT, newValue, null)) {
            String value = null;
            if (newValue != null) {
                value = "variant_" + newValue;
            }
            ClientObjectFactory.getClientObject(widget).set("customVariant", value);
        }
    }

    public static void renderData(Widget widget) {
        Object[] newValue = WidgetLCAUtil.getDataAsArray(widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_DATA, newValue, new Object[0])) {
            JsonObject data = new JsonObject();
            int i = 0;
            while (i < newValue.length) {
                data.add((String)newValue[i], JsonUtil.createJsonValue(newValue[++i]));
                ++i;
            }
            ClientObjectFactory.getClientObject(widget).set(PROP_DATA, data);
        }
    }

    private static Object[] getDataAsArray(Widget widget) {
        String[] dataKeys;
        ArrayList<Object> result = new ArrayList<Object>();
        WidgetDataWhiteList service = RWT.getClient().getService(WidgetDataWhiteList.class);
        String[] stringArray = dataKeys = service == null ? null : service.getKeys();
        if (dataKeys != null) {
            String[] stringArray2 = dataKeys;
            int n = dataKeys.length;
            int n2 = 0;
            while (n2 < n) {
                Object value;
                String key = stringArray2[n2];
                if (key != null && (value = widget.getData(key)) != null) {
                    result.add(key);
                    result.add(value);
                }
                ++n2;
            }
        }
        return result.toArray();
    }

    public static void renderListenHelp(Widget widget) {
        WidgetLCAUtil.renderListener(widget, PROP_HELP_LISTENER, EventLCAUtil.isListening(widget, 28), false);
    }

    public static void renderMenu(Widget widget, Menu menu) {
        WidgetLCAUtil.renderProperty(widget, "menu", menu, null);
    }

    public static void renderToolTip(Widget widget, String toolTip) {
        String text;
        String string = text = toolTip == null ? "" : toolTip;
        if (WidgetLCAUtil.hasChanged(widget, PROP_TOOL_TIP, text, "")) {
            ClientObjectFactory.getClientObject(widget).set(PROP_TOOL_TIP, MnemonicUtil.removeAmpersandControlCharacters(text));
        }
    }

    public static void renderFont(Widget widget, Font font) {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            ClientObjectFactory.getClientObject(widget).set(PROP_FONT, ProtocolUtil.getJsonForFont(font));
        }
    }

    public static void renderForeground(Widget widget, Color newColor) {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            ClientObjectFactory.getClientObject(widget).set(PROP_FOREGROUND, ProtocolUtil.getJsonForColor(newColor, false));
        }
    }

    public static void renderBackground(Widget widget, Color newColor) {
        WidgetLCAUtil.renderBackground(widget, newColor, false);
    }

    public static void renderBackground(Widget widget, Color background, boolean transparency) {
        boolean transparencyChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        boolean colorChanged = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        if (transparencyChanged || colorChanged) {
            JsonValue color = JsonValue.NULL;
            if (transparency || background != null) {
                color = ProtocolUtil.getJsonForColor(background, transparency);
            }
            ClientObjectFactory.getClientObject(widget).set(PROP_BACKGROUND, color);
        }
    }

    public static void renderBackgroundGradient(Widget widget) {
        if (WidgetLCAUtil.hasBackgroundGradientChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
            JsonValue args = JsonValue.NULL;
            if (bgGradientColors != null) {
                JsonArray colors = new JsonArray();
                int i = 0;
                while (i < bgGradientColors.length) {
                    colors.add(ProtocolUtil.getJsonForColor(bgGradientColors[i], false));
                    ++i;
                }
                int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
                JsonArray percents = JsonUtil.createJsonArray(bgGradientPercents);
                boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
                args = new JsonArray().add(colors).add(percents).add(bgGradientVertical);
            }
            ClientObjectFactory.getClientObject(widget).set("backgroundGradient", args);
        }
    }

    private static boolean hasBackgroundGradientChanged(Widget widget) {
        IWidgetGraphicsAdapter graphicsAdapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        Color[] bgGradientColors = graphicsAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = graphicsAdapter.getBackgroundGradientPercents();
        boolean bgGradientVertical = graphicsAdapter.isBackgroundGradientVertical();
        return WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_COLORS, bgGradientColors, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_PERCENTS, bgGradientPercents, null) || WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_GRADIENT_VERTICAL, bgGradientVertical, Boolean.FALSE);
    }

    public static void renderRoundedBorder(Widget widget) {
        if (WidgetLCAUtil.hasRoundedBorderChanged(widget)) {
            IWidgetGraphicsAdapter adapter;
            IWidgetGraphicsAdapter graphicAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
            JsonValue args = JsonValue.NULL;
            int width = graphicAdapter.getRoundedBorderWidth();
            Color color = graphicAdapter.getRoundedBorderColor();
            if (width > 0 && color != null) {
                Rectangle radius = graphicAdapter.getRoundedBorderRadius();
                args = new JsonArray().add(width).add(ProtocolUtil.getJsonForColor(color, false)).add(radius.x).add(radius.y).add(radius.width).add(radius.height);
            }
            ClientObjectFactory.getClientObject(widget).set("roundedBorder", args);
        }
    }

    private static boolean hasRoundedBorderChanged(Widget widget) {
        IWidgetGraphicsAdapter adapter;
        IWidgetGraphicsAdapter graphicsAdapter = adapter = widget.getAdapter(IWidgetGraphicsAdapter.class);
        int width = graphicsAdapter.getRoundedBorderWidth();
        Color color = graphicsAdapter.getRoundedBorderColor();
        Rectangle radius = graphicsAdapter.getRoundedBorderRadius();
        return WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_WIDTH, new Integer(width), new Integer(0)) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_COLOR, color, null) || WidgetLCAUtil.hasChanged(widget, PROP_ROUNDED_BORDER_RADIUS, radius, DEF_ROUNDED_BORDER_RADIUS);
    }

    public static String readPropertyValue(Widget widget, String property) {
        String widgetId = WidgetUtil.getId(widget);
        return ProtocolUtil.readPropertyValueAsString(widgetId, property);
    }

    public static String readEventPropertyValue(Widget widget, String eventName, String property) {
        String widgetId = WidgetUtil.getId(widget);
        return ProtocolUtil.readEventPropertyValueAsString(widgetId, eventName, property);
    }

    public static boolean wasEventSent(Widget widget, String eventName) {
        String widgetId = WidgetUtil.getId(widget);
        return ProtocolUtil.wasEventSent(widgetId, eventName);
    }

    public static void preserveProperty(Widget widget, String property, Object value) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(property, value);
    }

    public static void preserveProperty(Widget widget, String property, int value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void preserveProperty(Widget widget, String property, boolean value) {
        WidgetLCAUtil.preserveProperty(widget, property, (Object)value);
    }

    public static void preserveListener(Widget widget, String listener, boolean value) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        adapter.preserve(LISTENER_PREFIX + listener, new Boolean(value));
    }

    public static void renderProperty(Widget widget, String property, Object newValue, Object defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            ClientObjectFactory.getClientObject(widget).set(property, JsonUtil.createJsonValue(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, int newValue, int defaultValue) {
        Integer newValueObject = newValue;
        Integer defaultValueObject = defaultValue;
        WidgetLCAUtil.renderProperty(widget, property, newValueObject, defaultValueObject);
    }

    public static void renderProperty(Widget widget, String property, boolean newValue, boolean defaultValue) {
        Boolean newValueObject = newValue;
        Boolean defaultValueObject = defaultValue;
        WidgetLCAUtil.renderProperty(widget, property, newValueObject, defaultValueObject);
    }

    public static void renderProperty(Widget widget, String property, Image newValue, Image defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            ClientObjectFactory.getClientObject(widget).set(property, ProtocolUtil.getJsonForImage(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Image[] newValue, Image[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonArray images = new JsonArray();
            int i = 0;
            while (i < newValue.length) {
                images.add(ProtocolUtil.getJsonForImage(newValue[i]));
                ++i;
            }
            ClientObjectFactory.getClientObject(widget).set(property, images);
        }
    }

    public static void renderProperty(Widget widget, String property, Color newValue, Color defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            ClientObjectFactory.getClientObject(widget).set(property, ProtocolUtil.getJsonForColor(newValue, false));
        }
    }

    public static void renderProperty(Widget widget, String property, Color[] newValue, Color[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonArray colors = new JsonArray();
            int i = 0;
            while (i < newValue.length) {
                colors.add(ProtocolUtil.getJsonForColor(newValue[i], false));
                ++i;
            }
            ClientObjectFactory.getClientObject(widget).set(property, colors);
        }
    }

    public static void renderProperty(Widget widget, String property, Font[] newValue, Font[] defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            JsonArray fonts = new JsonArray();
            int i = 0;
            while (i < newValue.length) {
                fonts.add(ProtocolUtil.getJsonForFont(newValue[i]));
                ++i;
            }
            ClientObjectFactory.getClientObject(widget).set(property, fonts);
        }
    }

    public static void renderProperty(Widget widget, String property, Point newValue, Point defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            ClientObjectFactory.getClientObject(widget).set(property, ProtocolUtil.getJsonForPoint(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Rectangle newValue, Rectangle defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            ClientObjectFactory.getClientObject(widget).set(property, ProtocolUtil.getJsonForRectangle(newValue));
        }
    }

    public static void renderProperty(Widget widget, String property, Widget newValue, Widget defaultValue) {
        if (WidgetLCAUtil.hasChanged(widget, property, newValue, defaultValue)) {
            String widgetId = newValue == null ? null : WidgetUtil.getId(newValue);
            ClientObjectFactory.getClientObject(widget).set(property, widgetId);
        }
    }

    public static void renderListener(Widget widget, String listener, boolean newValue, boolean defaultValue) {
        Boolean defaultValueObject;
        Boolean newValueObject;
        String property = LISTENER_PREFIX + listener;
        if (WidgetLCAUtil.hasChanged(widget, property, newValueObject = Boolean.valueOf(newValue), defaultValueObject = Boolean.valueOf(defaultValue))) {
            ClientObjectFactory.getClientObject(widget).listen(listener, newValue);
        }
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        Object oldValue = adapter.getPreserved(property);
        return !WidgetLCAUtil.equals(oldValue, newValue);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue, Object defaultValue) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(widget);
        boolean result = adapter.isInitialized() ? WidgetLCAUtil.hasChanged(widget, property, newValue) : !WidgetLCAUtil.equals(newValue, defaultValue);
        return result;
    }

    public static String replaceNewLines(String input, String replacement) {
        return EncodingUtil.replaceNewLines(input, replacement);
    }

    public static String[] getStyles(Widget widget, String[] styles) {
        return StylesUtil.filterStyles(widget, styles);
    }

    static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : (object1 instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object1, (boolean[])object2) : (object1 instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object1, (int[])object2) : (object1 instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object1, (long[])object2) : (object1 instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object1, (float[])object2) : (object1 instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object1, (double[])object2) : (object1 instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object1, (Object[])object2) : object1.equals(object2))))))));
        return result;
    }
}

