/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.internal.RWTProperties;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ClassInstantiationException;
import org.eclipse.swt.internal.widgets.IdGenerator;
import org.eclipse.swt.internal.widgets.IdGeneratorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdGeneratorProvider {
    private static final String ATTR_ID_GENERATOR_CLASS = IdGeneratorProvider.class.getName().concat("#idGeneratorClass");

    private IdGeneratorProvider() {
    }

    public static IdGenerator getIdGenerator() {
        return SingletonUtil.getSessionInstance(IdGeneratorProvider.getIdGeneratorClass());
    }

    private static Class<? extends IdGenerator> getIdGeneratorClass() {
        ApplicationContextImpl applicationContext = ContextProvider.getApplicationContext();
        Class<? extends IdGenerator> result = applicationContext.getAttribute(ATTR_ID_GENERATOR_CLASS);
        if (result == null) {
            result = IdGeneratorProvider.getGeneratorClass();
            applicationContext.setAttribute(ATTR_ID_GENERATOR_CLASS, result);
        }
        return result;
    }

    private static Class<? extends IdGenerator> getGeneratorClass() {
        String className = RWTProperties.getIdGeneratorClassName();
        if (className != null) {
            return IdGeneratorProvider.loadCustomGeneratorClass(className);
        }
        return IdGeneratorImpl.class;
    }

    private static Class<? extends IdGenerator> loadCustomGeneratorClass(String className) {
        try {
            return IdGeneratorProvider.loadClass(className).asSubclass(IdGenerator.class);
        }
        catch (ClassCastException exception) {
            String message = "Class is not an instance of IdGenerator: " + className;
            throw new ClassInstantiationException(message, exception);
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return IdGeneratorProvider.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException exception) {
            throw new ClassInstantiationException("Failed to load class: " + className, exception);
        }
    }
}

