/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.expandbarkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.internal.widgets.ScrollBarLCAUtil;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public final class ExpandBarLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ExpandBar";
    private static final String[] ALLOWED_STYLES = new String[]{"NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_BOTTOM_SPACING_BOUNDS = "bottomSpacingBounds";
    private static final String PROP_VSCROLLBAR_MAX = "vScrollBarMax";
    private static final String PROP_EXPAND_LISTENER = "Expand";
    private static final String PROP_COLLAPSE_LISTENER = "Collapse";

    public void preserveValues(Widget widget) {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.preserveValues(expandBar);
        WidgetLCAUtil.preserveCustomVariant(expandBar);
        WidgetLCAUtil.preserveProperty((Widget)expandBar, PROP_BOTTOM_SPACING_BOUNDS, ExpandBarLCA.getBottomSpacingBounds(expandBar));
        WidgetLCAUtil.preserveProperty((Widget)expandBar, PROP_VSCROLLBAR_MAX, ExpandBarLCA.getVScrollBarMax(expandBar));
        WidgetLCAUtil.preserveListener(expandBar, PROP_EXPAND_LISTENER, ExpandBarLCA.hasExpandListener(expandBar));
        WidgetLCAUtil.preserveListener(expandBar, PROP_COLLAPSE_LISTENER, ExpandBarLCA.hasCollapseListener(expandBar));
        ScrollBarLCAUtil.preserveValues(expandBar);
    }

    public void readData(Widget widget) {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.processKeyEvents(expandBar);
        ControlLCAUtil.processMenuDetect(expandBar);
        WidgetLCAUtil.processHelp(expandBar);
        ExpandBarLCA.processExpandEvent(expandBar, 17, PROP_EXPAND_LISTENER);
        ExpandBarLCA.processExpandEvent(expandBar, 18, PROP_COLLAPSE_LISTENER);
        ScrollBarLCAUtil.processSelectionEvent(expandBar);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(expandBar);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(expandBar.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(expandBar, ALLOWED_STYLES)));
        ScrollBarLCAUtil.renderInitialization(expandBar);
    }

    public void renderChanges(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.renderChanges(expandBar);
        WidgetLCAUtil.renderCustomVariant(expandBar);
        WidgetLCAUtil.renderProperty((Widget)expandBar, PROP_BOTTOM_SPACING_BOUNDS, ExpandBarLCA.getBottomSpacingBounds(expandBar), null);
        WidgetLCAUtil.renderProperty((Widget)expandBar, PROP_VSCROLLBAR_MAX, ExpandBarLCA.getVScrollBarMax(expandBar), 0);
        WidgetLCAUtil.renderListener(expandBar, PROP_EXPAND_LISTENER, ExpandBarLCA.hasExpandListener(expandBar), false);
        WidgetLCAUtil.renderListener(expandBar, PROP_COLLAPSE_LISTENER, ExpandBarLCA.hasCollapseListener(expandBar), false);
        ScrollBarLCAUtil.renderChanges(expandBar);
    }

    private static Rectangle getBottomSpacingBounds(ExpandBar bar) {
        return ExpandBarLCA.getExpandBarAdapter(bar).getBottomSpacingBounds();
    }

    private static int getVScrollBarMax(ExpandBar bar) {
        int result = 0;
        if ((bar.getStyle() & 0x200) != 0) {
            IExpandBarAdapter expandBarAdapter = ExpandBarLCA.getExpandBarAdapter(bar);
            ExpandItem[] items = bar.getItems();
            int i = 0;
            while (i < items.length) {
                result += expandBarAdapter.getBounds((ExpandItem)items[i]).height;
                ++i;
            }
            result += bar.getSpacing() * (items.length + 1);
        }
        return result;
    }

    private static boolean hasExpandListener(ExpandBar bar) {
        return true;
    }

    private static boolean hasCollapseListener(ExpandBar bar) {
        return true;
    }

    public static IExpandBarAdapter getExpandBarAdapter(ExpandBar bar) {
        return bar.getAdapter(IExpandBarAdapter.class);
    }

    private static void processExpandEvent(ExpandBar bar, int eventType, String eventName) {
        if (WidgetLCAUtil.wasEventSent(bar, eventName)) {
            String value = WidgetLCAUtil.readEventPropertyValue(bar, eventName, "item");
            Event event = new Event();
            event.item = ExpandBarLCA.getItem(bar, value);
            bar.notifyListeners(eventType, event);
        }
    }

    private static ExpandItem getItem(ExpandBar bar, String itemId) {
        return (ExpandItem)WidgetUtil.find(bar, itemId);
    }
}

