/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.util;

import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;

public final class URLBuilder {
    private static final String EMPTY = "";
    private static final String SLASH = "/";
    private static final String PROTOCOL = "http";
    private static final String HOST = "127.0.0.1";

    public static String fromLaunchConfig(RWTLaunchConfig config) {
        String port = config.getUseManualPort() ? Integer.toString(config.getPort()) : "<PORT>";
        return "http://127.0.0.1:" + port + URLBuilder.getUrlPath(config);
    }

    private static String getUrlPath(RWTLaunchConfig config) {
        String contextPath = URLBuilder.getContextPath(config);
        String servletPath = URLBuilder.getServletPath(config);
        StringBuffer buffer = new StringBuffer();
        buffer.append(SLASH);
        if (!EMPTY.equals(contextPath)) {
            buffer.append(contextPath);
            buffer.append(SLASH);
        }
        buffer.append(servletPath);
        return buffer.toString();
    }

    private static String getServletPath(RWTLaunchConfig config) {
        String servletPath = config.getServletPath();
        return URLBuilder.stripLeadingAndTrailingSlashes(servletPath);
    }

    private static String getContextPath(RWTLaunchConfig config) {
        String contextPath = EMPTY;
        if (config.getUseManualContextPath()) {
            contextPath = config.getContextPath();
        }
        return URLBuilder.stripLeadingAndTrailingSlashes(contextPath);
    }

    private static String stripLeadingAndTrailingSlashes(String input) {
        String result = input;
        if (result.startsWith(SLASH)) {
            result = result.substring(1);
        }
        if (result.endsWith(SLASH)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private URLBuilder() {
    }
}

