/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.internal.completion.rcp.BaseRecommendersCompletionContext;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.rcp.JdtUtils;

public class RecommendersCompletionContext
extends BaseRecommendersCompletionContext {
    @Inject
    public RecommendersCompletionContext(@Assisted JavaContentAssistInvocationContext jdtContext, IAstProvider astProvider) {
        super(jdtContext, astProvider);
    }

    public Optional<ASTNode> getCompletionNode() {
        InternalCompletionContext ctx = (InternalCompletionContext)this.getCoreContext().orNull();
        ASTNode res = ctx != null ? ctx.getCompletionNode() : null;
        return Optional.fromNullable((Object)res);
    }

    public Optional<ASTNode> getCompletionNodeParent() {
        InternalCompletionContext ctx = (InternalCompletionContext)this.getCoreContext().orNull();
        ASTNode res = ctx != null ? ctx.getCompletionNodeParent() : null;
        return Optional.fromNullable((Object)res);
    }

    public List<IField> getVisibleFields() {
        InternalCompletionContext ctx = (InternalCompletionContext)this.getCoreContext().orNull();
        if (ctx == null || !ctx.isExtended()) {
            return Collections.emptyList();
        }
        ObjectVector v = ctx.getVisibleFields();
        ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
        int i = v.size();
        while (i-- > 0) {
            FieldBinding b = (FieldBinding)Checks.cast((Object)v.elementAt(i));
            Optional f = JdtUtils.createUnresolvedField((FieldBinding)b);
            if (!f.isPresent()) continue;
            res.add((IField)f.get());
        }
        return res;
    }

    public List<ILocalVariable> getVisibleLocals() {
        InternalCompletionContext ctx = (InternalCompletionContext)this.getCoreContext().orNull();
        if (ctx == null || !ctx.isExtended()) {
            return Collections.emptyList();
        }
        ObjectVector v = ctx.getVisibleLocalVariables();
        ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
        int i = v.size();
        while (i-- > 0) {
            LocalVariableBinding b = (LocalVariableBinding)Checks.cast((Object)v.elementAt(i));
            JavaElement parent = (JavaElement)this.getEnclosingElement().get();
            ILocalVariable f = JdtUtils.createUnresolvedLocaVariable((VariableBinding)b, (JavaElement)parent);
            res.add(f);
        }
        return res;
    }

    public List<IMethod> getVisibleMethods() {
        InternalCompletionContext ctx = (InternalCompletionContext)this.getCoreContext().orNull();
        if (ctx == null || !ctx.isExtended()) {
            return Collections.emptyList();
        }
        ObjectVector v = ctx.getVisibleMethods();
        ArrayList res = Lists.newArrayListWithCapacity((int)v.size);
        int i = v.size();
        while (i-- > 0) {
            MethodBinding b = (MethodBinding)Checks.cast((Object)v.elementAt(i));
            Optional f = JdtUtils.createUnresolvedMethod((MethodBinding)b);
            if (!f.isPresent()) continue;
            res.add((IMethod)f.get());
        }
        return res;
    }
}

