/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.subwords;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;

public class SubwordsUtils {
    static final String JDT_ALL_CATEGORY = "org.eclipse.jdt.ui.javaAllProposalCategory";
    static final String MYLYN_ALL_CATEGORY = "org.eclipse.mylyn.java.ui.javaAllProposalCategory";

    public static String getTokensBetweenLastWhitespaceAndFirstOpeningBracket(CompletionProposal proposal) {
        boolean isPotentialMethodDecl = proposal.getKind() == 11;
        char[] token = proposal.getCompletion();
        if (Arrays.equals(token, new char[]{'(', ')'})) {
            token = proposal.getName();
        } else if (isPotentialMethodDecl && proposal.getCompletion().length == 0) {
            char[] signature = proposal.getDeclarationSignature();
            char[] typeName = Signature.getSignatureSimpleName((char[])signature);
            return String.valueOf(typeName);
        }
        return SubwordsUtils.getTokensBetweenLastWhitespaceAndFirstOpeningBracket(String.valueOf(token));
    }

    public static String getTokensBetweenLastWhitespaceAndFirstOpeningBracket(String completion) {
        completion = completion.contains("(") ? SubwordsUtils.getMethodIdentifierFromProposalText(completion) : StringUtils.substringBefore((String)completion, (String)" ");
        return completion;
    }

    private static String getMethodIdentifierFromProposalText(String completion) {
        if ((completion = StringUtils.substringBefore((String)completion, (String)"(")).contains(" ")) {
            completion = StringUtils.substringAfterLast((String)completion, (String)" ");
        }
        return completion;
    }

    public static boolean isMylynInstalled() {
        CompletionProposalComputerRegistry reg = CompletionProposalComputerRegistry.getDefault();
        for (CompletionProposalCategory cat : reg.getProposalCategories()) {
            if (!cat.getId().equals(MYLYN_ALL_CATEGORY)) continue;
            return true;
        }
        return false;
    }
}

