/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.subwords.proposals;

import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.FilledArgumentNamesMethodProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.OverrideCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.internal.completion.rcp.subwords.SubwordsProposalContext;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwAnonymousTypeCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwFilledArgumentNamesMethodProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwJavaCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwJavaFieldWithCastedReceiverCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwJavaMethodCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwLazyGenericTypeProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwLazyJavaTypeCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwOverrideCompletionProposal;
import org.eclipse.recommenders.internal.completion.rcp.subwords.proposals.SwParameterGuessingProposal;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;
import org.eclipse.swt.graphics.Image;

public class ProposalFactory {
    public static IJavaCompletionProposal createFromJDTProposal(SubwordsProposalContext subwordsContext) {
        Object jdtProposal = subwordsContext.getJdtProposal();
        Class<?> c = jdtProposal.getClass();
        try {
            if (JavaMethodCompletionProposal.class == c) {
                return ProposalFactory.createJavaMethodCompletionProposal(subwordsContext);
            }
            if (JavaFieldWithCastedReceiverCompletionProposal.class == c) {
                return ProposalFactory.createJavaFieldWithCastedReceiverCompletionProposal(subwordsContext);
            }
            if (OverrideCompletionProposal.class == c) {
                return ProposalFactory.createOverrideCompletionProposal(subwordsContext);
            }
            if (AnonymousTypeCompletionProposal.class == c) {
                return ProposalFactory.createAnonymousTypeCompletionProposal(subwordsContext);
            }
            if (JavaCompletionProposal.class == c) {
                return ProposalFactory.createJavaCompletionProposal(subwordsContext);
            }
            if (LazyGenericTypeProposal.class == c) {
                return ProposalFactory.createLazyGenericTypeProposal(subwordsContext);
            }
            if (LazyJavaTypeCompletionProposal.class == c) {
                return ProposalFactory.createLazyJavaTypeCompletionProposal(subwordsContext);
            }
            if (FilledArgumentNamesMethodProposal.class == c) {
                return ProposalFactory.createFilledArgumentNamesMethodProposal(subwordsContext);
            }
            if (ParameterGuessingProposal.class == c) {
                return ProposalFactory.createParameterGuessingProposal(subwordsContext);
            }
        }
        catch (Exception e) {
            RecommendersUtilsPlugin.logError((Exception)e, (String)"wrapping jdt proposal failed", (Object[])new Object[0]);
        }
        return jdtProposal;
    }

    private static IJavaCompletionProposal createLazyGenericTypeProposal(SubwordsProposalContext subwordsContext) {
        return new SwLazyGenericTypeProposal(subwordsContext.getProposal(), subwordsContext.getContext(), subwordsContext);
    }

    private static IJavaCompletionProposal createFilledArgumentNamesMethodProposal(SubwordsProposalContext subwordsContext) {
        return new SwFilledArgumentNamesMethodProposal(subwordsContext.getProposal(), subwordsContext.getContext(), subwordsContext);
    }

    public static SwParameterGuessingProposal createParameterGuessingProposal(SubwordsProposalContext subwordsContext) {
        CompletionProposal proposal = subwordsContext.getProposal();
        JavaContentAssistInvocationContext context = subwordsContext.getContext();
        boolean fillBestGuess = ProposalFactory.shouldFillArgumentNames();
        CompletionContext coreContext = context.getCoreContext();
        return new SwParameterGuessingProposal(proposal, context, coreContext, fillBestGuess, subwordsContext);
    }

    private static boolean shouldFillArgumentNames() {
        try {
            boolean res = PreferenceConstants.getPreferenceStore().getBoolean("content_assist_guess_method_arguments");
            return res;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static SwAnonymousTypeCompletionProposal createAnonymousTypeCompletionProposal(SubwordsProposalContext subwordsContext) throws JavaModelException {
        JavaContentAssistInvocationContext context = subwordsContext.getContext();
        CompletionProposal proposal = subwordsContext.getProposal();
        JavaCompletionProposal jdtProposal = (JavaCompletionProposal)subwordsContext.getJdtProposal();
        IJavaProject project = context.getProject();
        String declarationSignature = String.valueOf(proposal.getDeclarationSignature());
        String declarationKey = String.valueOf(proposal.getDeclarationKey());
        String completionText = String.valueOf(proposal.getCompletion());
        return new SwAnonymousTypeCompletionProposal(project, context.getCompilationUnit(), context, proposal.getReplaceStart(), jdtProposal.getReplacementLength(), completionText, jdtProposal.getStyledDisplayString(), declarationSignature, (IType)project.findElement(declarationKey, null), jdtProposal.getRelevance(), subwordsContext);
    }

    public static SwJavaFieldWithCastedReceiverCompletionProposal createJavaFieldWithCastedReceiverCompletionProposal(SubwordsProposalContext subwordsContext) {
        JavaCompletionProposal jdtProposal = (JavaCompletionProposal)subwordsContext.getJdtProposal();
        int relevance = subwordsContext.calculateRelevance();
        return new SwJavaFieldWithCastedReceiverCompletionProposal(jdtProposal.getDisplayString(), jdtProposal.getReplacementOffset(), jdtProposal.getReplacementLength(), jdtProposal.getImage(), jdtProposal.getStyledDisplayString(), relevance, true, subwordsContext.getContext(), subwordsContext.getProposal(), subwordsContext);
    }

    public static SwJavaCompletionProposal createJavaCompletionProposal(SubwordsProposalContext subwordsContext) {
        JavaCompletionProposal jdtProposal = (JavaCompletionProposal)subwordsContext.getJdtProposal();
        int relevance = subwordsContext.calculateRelevance();
        return new SwJavaCompletionProposal(jdtProposal.getReplacementString(), subwordsContext.getProposal().getReplaceStart(), jdtProposal.getReplacementLength(), jdtProposal.getImage(), jdtProposal.getStyledDisplayString(), relevance, true, subwordsContext.getContext(), subwordsContext);
    }

    public static SwJavaMethodCompletionProposal createJavaMethodCompletionProposal(SubwordsProposalContext subwordsContext) {
        SwJavaMethodCompletionProposal res = new SwJavaMethodCompletionProposal(subwordsContext.getProposal(), subwordsContext.getContext(), subwordsContext);
        res.setRelevance(subwordsContext.calculateRelevance());
        return res;
    }

    public static SwLazyJavaTypeCompletionProposal createLazyJavaTypeCompletionProposal(SubwordsProposalContext subwordsContext) {
        CompletionProposal proposal = subwordsContext.getProposal();
        SwLazyJavaTypeCompletionProposal res = new SwLazyJavaTypeCompletionProposal(proposal, subwordsContext.getContext(), subwordsContext);
        res.setRelevance(proposal.getRelevance());
        return res;
    }

    public static SwOverrideCompletionProposal createOverrideCompletionProposal(SubwordsProposalContext subwordsContext) {
        JavaContentAssistInvocationContext context = subwordsContext.getContext();
        JavaCompletionProposal jdtProposal = (JavaCompletionProposal)subwordsContext.getJdtProposal();
        CompletionProposal proposal = subwordsContext.getProposal();
        String completionText = String.valueOf(proposal.getCompletion());
        String proposalName = String.valueOf(proposal.getName());
        String[] paramTypes = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
        int index = 0;
        while (index < paramTypes.length) {
            paramTypes[index] = Signature.toString((String)paramTypes[index]);
            ++index;
        }
        SwOverrideCompletionProposal res = new SwOverrideCompletionProposal(context.getProject(), context.getCompilationUnit(), proposalName, paramTypes, proposal.getReplaceStart(), jdtProposal.getReplacementLength(), jdtProposal.getStyledDisplayString(), completionText, subwordsContext);
        Image image = jdtProposal.getImage();
        res.setImage(image);
        res.setRelevance(jdtProposal.getRelevance());
        return res;
    }
}

