/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.util;

public class MathUtils {
    public static void exp(double[] vector) {
        int i = 0;
        while (i < vector.length) {
            vector[i] = Math.exp(vector[i]);
            ++i;
        }
    }

    public static void log(double[] vector) {
        int i = 0;
        while (i < vector.length) {
            vector[i] = Math.log(vector[i]);
            ++i;
        }
    }

    public static double[] normalize(double[] vector) {
        double normFactor = MathUtils.sum(vector);
        if (normFactor == 0.0) {
            throw new IllegalArgumentException("Cannot normalize a zero-Vector!");
        }
        int i = 0;
        while (i < vector.length) {
            int n = i++;
            vector[n] = vector[n] / normFactor;
        }
        return vector;
    }

    public static double sum(double[] vector) {
        double result = 0.0;
        double[] dArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            result += d;
            ++n2;
        }
        return result;
    }

    public static void secureDivide(double[] a, double[] b, double[] c) {
        int i = 0;
        while (i < a.length) {
            if (b[i] != 0.0) {
                c[i] = a[i] / b[i];
            }
            ++i;
        }
    }

    public static void secureSubtract(double[] a, double[] b, double[] c) {
        int i = 0;
        while (i < a.length) {
            if (b[i] != Double.NEGATIVE_INFINITY) {
                c[i] = a[i] - b[i];
            }
            ++i;
        }
    }

    public static double[] normalizeLog(double[] vector) {
        double normFactor = MathUtils.logsumexp(vector);
        if (normFactor == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Cannot normalize a zero-Vector!");
        }
        int i = 0;
        while (i < vector.length) {
            int n = i++;
            vector[n] = vector[n] - normFactor;
        }
        return vector;
    }

    private static double logsumexp(double[] vector) {
        double max = MathUtils.absMax(vector);
        double sum = 0.0;
        double[] dArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += Math.exp(d - max);
            ++n2;
        }
        sum = max + Math.log(sum);
        return sum;
    }

    private static double absMax(double[] vector) {
        double result = 0.0;
        double[] dArray = vector;
        int n = vector.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d != Double.NEGATIVE_INFINITY && Math.abs(d) > Math.abs(result)) {
                result = d;
            }
            ++n2;
        }
        return result;
    }
}

