/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.models.archive;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.recommenders.internal.rcp.models.IModelArchive;
import org.eclipse.recommenders.internal.rcp.models.archive.IModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingModelArchive<K, M>
implements IModelArchive<K, M> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Cache<K, M> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(100).build((CacheLoader)new CacheLoaderWrapper());
    private final IModelFactory<K, M> loader;

    public CachingModelArchive(IModelFactory<K, M> loader) {
        this.loader = loader;
    }

    @Override
    public boolean hasModel(K key) {
        try {
            return this.loader.hasModel(key);
        }
        catch (Exception e) {
            this.log.debug("Exception occurred while checking model existence for key " + key, (Throwable)e);
            return false;
        }
    }

    @Override
    public Optional<M> acquireModel(K key) {
        try {
            return Optional.fromNullable((Object)this.cache.get(key));
        }
        catch (Exception e) {
            this.log.debug("Exception occurred while fetching model for key " + key, (Throwable)e);
            return Optional.absent();
        }
    }

    @Override
    public void releaseModel(M value) {
    }

    @Override
    public void open() {
        this.loader.open();
    }

    @Override
    public void close() throws IOException {
        this.loader.close();
    }

    private final class CacheLoaderWrapper
    extends CacheLoader<K, M> {
        private CacheLoaderWrapper() {
        }

        public M load(K key) throws Exception {
            Object model = CachingModelArchive.this.loader.createModel(key);
            CachingModelArchive.this.loader.activateModel(key, model);
            return model;
        }
    }
}

