/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.models.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.internal.rcp.models.ModelArchiveMetadata;
import org.eclipse.recommenders.rcp.ClasspathEntryInfo;
import org.eclipse.recommenders.rcp.IClasspathEntryInfoProvider;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.l10n.Messages;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;
import org.eclipse.recommenders.utils.Version;
import org.sonatype.aether.artifact.Artifact;

public class ModelArchiveResolutionJob
extends Job {
    private final ModelArchiveMetadata metadata;
    private final IClasspathEntryInfoProvider cpeInfos;
    private final IModelRepository repository;
    private ClasspathEntryInfo cpeInfo;
    private File pkgRoot;
    private final IModelRepositoryIndex index;
    private final String classifier;
    private Artifact model;

    @Inject
    public ModelArchiveResolutionJob(@Assisted ModelArchiveMetadata metadata, IClasspathEntryInfoProvider cpeInfoProvider, IModelRepository repository, IModelRepositoryIndex index, @Assisted String classifier) {
        super(String.format(Messages.JOB_RESOLVING_MODEL, metadata.getLocation().getName()));
        this.metadata = metadata;
        this.cpeInfos = cpeInfoProvider;
        this.repository = repository;
        this.index = index;
        this.classifier = classifier;
    }

    @VisibleForTesting
    public IStatus run(IProgressMonitor monitor) {
        if (!this.isAutoDownloadAllowed()) {
            return Status.CANCEL_STATUS;
        }
        monitor.beginTask(String.format(Messages.TASK_LOOKING_FOR_MODEL, this.classifier, this.metadata.getLocation().getName()), 5);
        monitor.worked(1);
        this.metadata.setStatus(ModelArchiveMetadata.ModelArchiveResolutionStatus.UNRESOLVED);
        try {
            if (!this.findClasspathInfo()) {
                this.metadata.setError(String.format("No class path info available for '%s'. Skipped.", this.pkgRoot));
                this.metadata.setResolutionRequestedSinceStartup(false);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (!this.findInIndex()) {
                this.metadata.setError(String.format("No call model found for '%1$s'. Neither fingerprint '%2$s' nor symbolic name '%3$s' are known.", this.cpeInfo.getLocation(), this.cpeInfo.getFingerprint(), this.cpeInfo.getSymbolicName()));
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.worked(1);
            this.findBestMatchingLatestModel();
            monitor.worked(1);
            this.repository.resolve(this.model, monitor);
            monitor.worked(2);
            this.updateMetadata();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception x) {
            this.metadata.setStatus(ModelArchiveMetadata.ModelArchiveResolutionStatus.UNRESOLVED);
            this.metadata.setError(x.getMessage());
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    @VisibleForTesting
    protected boolean isAutoDownloadAllowed() {
        IPreferenceStore store = RecommendersPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(RecommendersPlugin.P_REPOSITORY_ENABLE_AUTO_DOWNLOAD);
    }

    private void updateMetadata() {
        this.metadata.setStatus(ModelArchiveMetadata.ModelArchiveResolutionStatus.RESOLVED);
        this.metadata.setArtifact(this.model);
        this.metadata.setCoordinate(this.model.toString());
    }

    private boolean findClasspathInfo() {
        this.pkgRoot = this.metadata.getLocation();
        this.cpeInfo = (ClasspathEntryInfo)this.cpeInfos.getInfo(this.pkgRoot).orNull();
        return this.cpeInfo != null;
    }

    private boolean findInIndex() {
        Optional<Artifact> tmp = Optional.absent();
        if (!StringUtils.isEmpty((CharSequence)this.cpeInfo.getFingerprint())) {
            tmp = this.index.searchByFingerprint(this.cpeInfo.getFingerprint(), this.classifier);
        }
        if (!tmp.isPresent() && !StringUtils.isEmpty((CharSequence)this.cpeInfo.getSymbolicName())) {
            tmp = this.index.searchByArtifactId(this.cpeInfo.getSymbolicName(), this.classifier);
        }
        this.model = (Artifact)tmp.orNull();
        return tmp.isPresent();
    }

    private void findBestMatchingLatestModel() {
        Version version = this.cpeInfo.getVersion();
        Artifact copy = this.model;
        Artifact query = null;
        String upperBound = version.isUnknown() ? "10000.0" : String.format("%d.%d", version.major, version.minor + 1);
        query = this.model.setVersion("[0," + upperBound + ")");
        copy = (Artifact)this.repository.findHigestVersion(query).orNull();
        if (copy == null) {
            query = this.model.setVersion("[" + upperBound + ",)");
            copy = (Artifact)this.repository.findLowestVersion(query).orNull();
        }
        if (copy != null) {
            this.model = copy;
        }
    }
}

