/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.repo;

import java.net.URI;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.RemoteRepository;

public class ServiceBasedProxySelector
implements ProxySelector {
    private final IProxyService proxyService;

    public ServiceBasedProxySelector(IProxyService proxyService) {
        this.proxyService = proxyService;
    }

    public Proxy getProxy(RemoteRepository remote) {
        if (this.proxyService == null) {
            return null;
        }
        if (!this.proxyService.isProxiesEnabled()) {
            return null;
        }
        URI uri = URI.create(remote.getUrl());
        if (uri.getHost() == null) {
            return null;
        }
        IProxyData[] entries = this.proxyService.select(uri);
        if (entries.length == 0) {
            return null;
        }
        IProxyData proxyData = entries[0];
        String type = proxyData.getType().toLowerCase();
        String host = proxyData.getHost();
        int port = proxyData.getPort();
        Authentication auth = new Authentication(proxyData.getUserId(), proxyData.getPassword());
        return new Proxy(type, host, port, auth);
    }
}

