/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp.ast;

import com.google.common.base.Optional;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Names;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.rcp.ast.BindingUtils;
import org.eclipse.recommenders.utils.rcp.internal.RecommendersUtilsPlugin;

public class ASTNodeUtils {
    public static SimpleName stripQualifier(Name name) {
        switch (name.getNodeType()) {
            case 42: {
                return (SimpleName)name;
            }
            case 40: {
                return ((QualifiedName)name).getName();
            }
        }
        throw Throws.throwUnreachable((String)"unknow subtype of name: '%s'", (Object[])new Object[]{name.getClass()});
    }

    public static boolean sameSimpleName(Type jdtParam, ITypeName crParam) {
        String jdtTypeName = ASTNodeUtils.toSimpleName(jdtParam);
        String crSimpleName = ASTNodeUtils.toSimpleName(crParam);
        return jdtTypeName.equals(crSimpleName);
    }

    private static String toSimpleName(ITypeName crParam) {
        String crSimpleName = Names.vm2srcSimpleTypeName((ITypeName)crParam);
        if (crSimpleName.contains("$")) {
            crSimpleName = StringUtils.substringAfterLast((String)crSimpleName, (String)"$");
        }
        return crSimpleName;
    }

    private static String toSimpleName(Type type) {
        SimpleName name;
        switch (type.getNodeType()) {
            case 43: {
                SimpleType t = (SimpleType)Checks.cast((Object)type);
                name = ASTNodeUtils.stripQualifier(t.getName());
                break;
            }
            case 75: {
                QualifiedType t = (QualifiedType)Checks.cast((Object)type);
                name = ASTNodeUtils.stripQualifier((Name)t.getName());
                break;
            }
            case 74: {
                ParameterizedType t = (ParameterizedType)Checks.cast((Object)type);
                return ASTNodeUtils.toSimpleName(t.getType());
            }
            case 39: {
                PrimitiveType t = (PrimitiveType)Checks.cast((Object)type);
                return t.getPrimitiveTypeCode().toString();
            }
            case 76: {
                WildcardType t = (WildcardType)Checks.cast((Object)type);
                return ASTNodeUtils.toSimpleName(t.getBound());
            }
            case 84: {
                UnionType t = (UnionType)Checks.cast((Object)type);
                return "UnionType" + t.types().toString();
            }
            case 5: {
                ArrayType t = (ArrayType)Checks.cast((Object)type);
                return String.valueOf(ASTNodeUtils.toSimpleName(t.getElementType())) + StringUtils.repeat((String)"[]", (int)t.getDimensions());
            }
            default: {
                throw Throws.throwUnreachable((String)"no support for type '%s'", (Object[])new Object[]{type});
            }
        }
        return name.getIdentifier();
    }

    public static Type getBaseType(Type jdtType) {
        if (!jdtType.isArrayType()) {
            return jdtType;
        }
        ArrayType arrayType = (ArrayType)jdtType;
        return ASTNodeUtils.getBaseType(arrayType.getComponentType());
    }

    public static int getLineNumberOfNodeStart(CompilationUnit cuNode, ASTNode node) {
        int startPosition = node.getStartPosition();
        int lineNumber = cuNode.getLineNumber(startPosition);
        return lineNumber;
    }

    public static int getLineNumberOfNodeEnd(CompilationUnit cuNode, ASTNode node) {
        int endPosition = node.getStartPosition() + node.getLength();
        int lineNumber = cuNode.getLineNumber(endPosition);
        return lineNumber;
    }

    public static boolean haveSameNumberOfParameters(List<SingleVariableDeclaration> jdtParams, ITypeName[] crParams) {
        return crParams.length == jdtParams.size();
    }

    public static boolean sameSimpleName(MethodDeclaration decl, IMethodName crMethod) {
        String methodName = decl.getName().toString();
        if (crMethod.isInit()) {
            ITypeName declaringType = crMethod.getDeclaringType();
            String className = declaringType.getClassName();
            boolean sameMethodName = className.equals(methodName);
            return sameMethodName;
        }
        boolean sameMethodName = methodName.equals(crMethod.getName());
        return sameMethodName;
    }

    public static boolean sameSimpleName(MethodInvocation invoke, IMethodName crMethod) {
        String methodName = invoke.getName().toString();
        if (crMethod.isInit()) {
            ITypeName declaringType = crMethod.getDeclaringType();
            String className = declaringType.getClassName();
            boolean sameMethodName = className.equals(methodName);
            return sameMethodName;
        }
        boolean sameMethodName = methodName.equals(crMethod.getName());
        return sameMethodName;
    }

    public static boolean haveSameParameterTypes(List<SingleVariableDeclaration> jdtParams, ITypeName[] crParams) {
        int i = crParams.length;
        while (i-- > 0) {
            Type jdtParam = jdtParams.get(i).getType();
            jdtParam = ASTNodeUtils.getBaseType(jdtParam);
            ITypeName crParam = crParams[i];
            if (jdtParam.isArrayType()) {
                int crDimensions;
                if (!crParam.isArrayType()) {
                    return false;
                }
                ArrayType jdtArrayType = (ArrayType)jdtParam;
                int jdtDimensions = jdtArrayType.getDimensions();
                if (jdtDimensions != (crDimensions = crParam.getArrayDimensions())) {
                    return false;
                }
                return !ASTNodeUtils.sameSimpleName(ASTNodeUtils.getBaseType((Type)jdtArrayType), crParam.getArrayBaseType());
            }
            if (jdtParam.isPrimitiveType() || ASTNodeUtils.sameSimpleName(jdtParam, crParam)) continue;
            return false;
        }
        return true;
    }

    public static boolean sameTypes(List<Type> jdtTypes, ITypeName[] crTypes) {
        int i = crTypes.length;
        while (--i > 0) {
            ITypeName crType;
            Type jdtType = jdtTypes.get(i);
            if (ASTNodeUtils.sameType(jdtType, crType = crTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean sameType(Type jdtType, ITypeName crType) {
        if (jdtType == null || crType == null) {
            return false;
        }
        if (jdtType.isArrayType() || jdtType.isPrimitiveType()) {
            return true;
        }
        if (jdtType.isSimpleType() && !ASTNodeUtils.sameSimpleName(jdtType, crType)) {
            return false;
        }
        ITypeBinding jdtTypeBinding = jdtType.resolveBinding();
        return ASTNodeUtils.sameType(jdtTypeBinding, crType);
    }

    public static boolean sameType(ITypeBinding jdtType, ITypeName crType) {
        Optional<ITypeName> opt = BindingUtils.toTypeName(jdtType);
        if (opt.isPresent()) {
            return ((ITypeName)opt.get()).equals(crType);
        }
        return false;
    }

    public static <T extends ASTNode> Optional<T> getClosestParent(ASTNode node, Class<T> nodeClass) {
        while (node != null) {
            if (nodeClass.isInstance(node)) {
                return Optional.of((Object)node);
            }
            node = node.getParent();
        }
        return Optional.absent();
    }

    public static Optional<MethodDeclaration> find(CompilationUnit cu, IMethod method) {
        try {
            ISourceRange nameRange = method.getNameRange();
            if (nameRange == null || nameRange.getOffset() == -1) {
                return ASTNodeUtils.useVisitor(cu, method);
            }
            ASTNode node = NodeFinder.perform((ASTNode)cu, (ISourceRange)nameRange);
            Optional<MethodDeclaration> opt = ASTNodeUtils.getClosestParent(node, MethodDeclaration.class);
            return opt;
        }
        catch (JavaModelException e) {
            RecommendersUtilsPlugin.log((CoreException)e);
            return Optional.absent();
        }
    }

    private static Optional<MethodDeclaration> useVisitor(final CompilationUnit cu, final IMethod member) {
        return new Finder<Optional<MethodDeclaration>>(){
            private MethodDeclaration res;

            @Override
            public Optional<MethodDeclaration> call() {
                try {
                    cu.accept((ASTVisitor)this);
                }
                catch (Exception exception) {}
                return Optional.of((Object)this.res);
            }

            public boolean visit(MethodDeclaration node) {
                IMethodBinding b = node.resolveBinding();
                if (member.equals(b.getJavaElement())) {
                    this.res = node;
                    Throws.throwCancelationException();
                }
                return true;
            }
        }.call();
    }

    private static abstract class Finder<T>
    extends ASTVisitor
    implements Callable<T> {
        private Finder() {
        }
    }
}

