/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.factory;

import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.factory.RemoteServiceFactory;
import org.eclipse.riena.core.util.Companion;
import org.eclipse.riena.internal.communication.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

public class RemoteServiceBuilder {
    private IRemoteServiceRegistration rsReg;

    protected void activate(ComponentContext context) {
        String serviceClassName = (String)context.getProperties().get("riena.interface");
        try {
            Class<?> serviceClass = Class.forName(serviceClassName);
            String path = (String)context.getProperties().get("riena.remote.path");
            String protocol = (String)context.getProperties().get("riena.remote.protocol");
            this.rsReg = ((RemoteServiceFactory)Companion.per(RemoteServiceFactory.class)).createAndRegisterProxy(serviceClass, path, protocol, Activator.getDefault().getContext());
        }
        catch (ClassNotFoundException e) {
            throw new RemoteFailure("RemoteServiceBuilder could not load class '" + serviceClassName + "'", e);
        }
    }

    public void ungetService(Bundle bundle, ServiceRegistration reg, Object service) {
        if (this.rsReg != null) {
            this.rsReg.unregister();
            this.rsReg = null;
        }
    }
}

