/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRUHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final int maxSize;
    private static final long serialVersionUID = -241795650048399135L;

    public LRUHashMap(int maxSize) {
        super(maxSize, 0.75f, true);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    public static <K, V> Map<K, V> createLRUHashMap(int maxSize) {
        return new LRUHashMap<K, V>(maxSize);
    }

    public static <K, V> Map<K, V> createSynchronizedLRUHashMap(int maxSize) {
        return Collections.synchronizedMap(new LRUHashMap<K, V>(maxSize));
    }
}

