/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.lang.reflect.Array;
import org.eclipse.core.runtime.Assert;

public final class ArraysUtil {
    private ArraysUtil() {
    }

    public static <T> T[] copyRange(T[] source, int from, int to) {
        Assert.isLegal((source != null ? 1 : 0) != 0, (String)"source array must no be null.");
        int length = to - from;
        Assert.isLegal((length >= 0 ? 1 : 0) != 0, (String)"to must be greater that from");
        Assert.isLegal((to <= source.length ? 1 : 0) != 0, (String)"to must be less or equal length of source array");
        Object[] target = (Object[])Array.newInstance(source.getClass().getComponentType(), length);
        System.arraycopy(source, from, target, 0, length);
        return target;
    }
}

