/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

public final class Base16Util {
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    private Base16Util() {
    }

    public static byte[] toBytes(String hexaString) {
        if (hexaString.length() % 2 == 1) {
            throw new IllegalArgumentException("String length must be even.");
        }
        byte[] bytes = new byte[hexaString.length() / 2];
        int bi = 0;
        int i = 0;
        while (bi < bytes.length) {
            int b = Character.digit(hexaString.charAt(i++), 16) << 4;
            bytes[bi] = (byte)(b |= Character.digit(hexaString.charAt(i++), 16));
            ++bi;
        }
        return bytes;
    }

    public static String toString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            chars[j++] = HEXDIGITS[bytes[i] >> 4 & 0xF];
            chars[j++] = HEXDIGITS[bytes[i] & 0xF];
            ++i;
        }
        return new String(chars);
    }
}

