/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.core.Activator;

public final class IOUtils {
    private static final int IO_BUFFER_SIZE = 8192;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), IOUtils.class);

    private IOUtils() {
    }

    public static void copyFile(File from, File to) throws IOException {
        Assert.isNotNull((Object)from, (String)"from");
        Assert.isNotNull((Object)to, (String)"to");
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        FileChannel sourceChannel = null;
        FileChannel destinationChannel = null;
        try {
            inputStream = new FileInputStream(from);
            sourceChannel = inputStream.getChannel();
            outputStream = new FileOutputStream(to);
            destinationChannel = outputStream.getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        }
        catch (Throwable throwable) {
            IOUtils.close(inputStream);
            IOUtils.close(outputStream);
            IOUtils.close(sourceChannel);
            IOUtils.close(destinationChannel);
            throw throwable;
        }
        IOUtils.close(inputStream);
        IOUtils.close(outputStream);
        IOUtils.close(sourceChannel);
        IOUtils.close(destinationChannel);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Assert.isNotNull((Object)inputStream, (String)"inputStream");
        Assert.isNotNull((Object)outputStream, (String)"outputStream");
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = inputStream.read(buffer, 0, 8192)) != -1) {
                outputStream.write(buffer, 0, read);
            }
        }
        finally {
            IOUtils.close(inputStream);
            IOUtils.close(outputStream);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.log(4, "Could not close given closeable.", (Throwable)e);
        }
    }
}

