/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.RienaPlugin;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.logging.ConsoleLogger;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.StartupsSafeRunnable;
import org.eclipse.riena.internal.core.exceptionmanager.SimpleExceptionHandlerManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class Activator
extends RienaPlugin {
    public static final String PLUGIN_ID = "org.eclipse.riena.core";
    private boolean active;
    private boolean startupActionsExecuted;
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.startStartupListener();
        this.startExceptionHandling();
    }

    private void startStartupListener() {
        StartupBundleListener bundleListener = new StartupBundleListener();
        this.getContext().addBundleListener((BundleListener)bundleListener);
    }

    private void startExceptionHandling() {
        SimpleExceptionHandlerManager handlerManager = new SimpleExceptionHandlerManager();
        Wire.instance(handlerManager).andStart(this.getContext());
        this.getContext().registerService(IExceptionHandlerManager.class.getName(), (Object)handlerManager, RienaConstants.newDefaultServiceProperties());
    }

    public void stop(BundleContext context) throws Exception {
        Job.getJobManager().cancel((Object)PLUGIN_ID);
        this.active = false;
        this.startupActionsExecuted = false;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean areStartupActionsExecuted() {
        return this.startupActionsExecuted;
    }

    private class StartupBundleListener
    implements BundleListener {
        private StartupBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (Activator.getDefault() == null) {
                new ConsoleLogger(StartupBundleListener.class.getName()).log(2, "Bundle already gone!");
                return;
            }
            try {
                if (event.getBundle() == this.getContextSave().getBundle() && event.getType() == 2) {
                    this.getContextSave().removeBundleListener((BundleListener)this);
                    Activator.this.active = true;
                    this.logStage();
                    StartupsSafeRunnable safeRunnable = new StartupsSafeRunnable();
                    Wire.instance(safeRunnable).andStart(this.getContextSave());
                    SafeRunner.run((ISafeRunnable)safeRunnable);
                    Activator.this.startupActionsExecuted = true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                new ConsoleLogger(StartupBundleListener.class.getName()).log(2, "BundleContext already gone!");
            }
        }

        private void logStage() {
            Log4r.getLogger(StartupBundleListener.class).log(3, "Riena is running in stage '" + RienaStatus.getStage() + "'.");
            String reportUnresolvedBundles = RienaStatus.reportUnresolvedBundles();
            if (reportUnresolvedBundles != null) {
                Log4r.getLogger(StartupBundleListener.class).log(1, reportUnresolvedBundles);
            }
        }

        private BundleContext getContextSave() {
            BundleContext context = Activator.this.getContext();
            if (context == null) {
                throw new IllegalStateException("BundleContext is <null>");
            }
            return context;
        }
    }
}

