/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.IRienaStartupExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class StartupsSafeRunnable
implements ISafeRunnable {
    private IRienaStartupExtension[] startups;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), StartupsSafeRunnable.class);
    private static final Comparator<IRienaStartupExtension> STARTUPS_COMPERATOR = new Comparator<IRienaStartupExtension>(){

        @Override
        public int compare(IRienaStartupExtension startup1, IRienaStartupExtension startup2) {
            return Integer.valueOf(this.getOrder(startup1)).compareTo(this.getOrder(startup2));
        }

        private int getOrder(IRienaStartupExtension startup) {
            if (startup.getWhen() == IRienaStartupExtension.When.BEGINNING) {
                return 0;
            }
            if (startup.getWhen() == null) {
                return 1;
            }
            if (startup.getWhen() == IRienaStartupExtension.When.END) {
                return 2;
            }
            LOGGER.log(1, "Unknown value for 'when' in startup definition: " + startup);
            return 1;
        }
    };

    public void handleException(Throwable exception) {
        IExceptionHandlerManager manager = Service.get(IExceptionHandlerManager.class);
        if (manager != null) {
            manager.handleException(exception, "Error activating bundels.", LOGGER);
            return;
        }
        LOGGER.log(1, "Error activating bundels.", exception);
    }

    public void run() throws Exception {
        if (this.startups == null) {
            return;
        }
        Arrays.sort(this.startups, STARTUPS_COMPERATOR);
        IRienaStartupExtension[] iRienaStartupExtensionArray = this.startups;
        int n = this.startups.length;
        int n2 = 0;
        while (n2 < n) {
            IRienaStartupExtension startup = iRienaStartupExtensionArray[n2];
            this.handleRequiredBundle(startup);
            this.handleRunClass(startup);
            this.handleSelfActivation(startup);
            ++n2;
        }
    }

    private void handleSelfActivation(IRienaStartupExtension startup) throws BundleException {
        if (!startup.isActivateSelf()) {
            return;
        }
        Bundle bundle = startup.getContributingBundle();
        if (bundle.getState() == 4) {
            this.start(bundle);
        } else if (bundle.getState() == 8 && "lazy".equals(bundle.getHeaders().get("Bundle-ActivationPolicy"))) {
            try {
                bundle.start();
                LOGGER.log(3, "Startup <<lazy>>: '" + bundle.getSymbolicName() + "' succesful.");
            }
            catch (BundleException be) {
                LOGGER.log(2, "Startup <<lazy>>: '" + bundle.getSymbolicName() + "' failed but may succeed (bundle state is in transition):\n\t\t" + be.getMessage() + (be.getCause() != null ? " cause: " + be.getCause() : ""));
            }
            catch (RuntimeException rte) {
                LOGGER.log(1, "Startup <<lazy>>:: '" + bundle.getSymbolicName() + "' failed with exception.", (Throwable)rte);
            }
        } else if (bundle.getState() == 2) {
            LOGGER.log(1, "Startup: '" + bundle.getSymbolicName() + "' failed. Startup extension is set but is only in state INSTALLED (not RESOLVED).");
        } else if (bundle.getState() == 32) {
            LOGGER.log(4, "Startup: '" + bundle.getSymbolicName() + "' is already ACTIVE.");
        }
    }

    private void handleRunClass(IRienaStartupExtension startup) {
        String runClassName = startup.getRunClassName();
        if (StringUtils.isEmpty(runClassName)) {
            return;
        }
        Bundle bundle = startup.getContributingBundle();
        try {
            startup.createRunner().run();
            LOGGER.log(3, "Startup: '" + bundle.getSymbolicName() + "' with starter '" + runClassName + "' succesful.");
        }
        catch (Exception e) {
            LOGGER.log(1, "Startup: '" + bundle.getSymbolicName() + "' with starter '" + runClassName + "' failed.", (Throwable)e);
        }
    }

    private void handleRequiredBundle(IRienaStartupExtension startup) throws BundleException {
        String[] bundleNames;
        String[] stringArray = bundleNames = PropertiesUtils.asArray(startup.getRequiredBundles());
        int n = bundleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleName = stringArray[n2];
            if (!StringUtils.isEmpty(bundleName)) {
                Bundle bundle = Platform.getBundle((String)bundleName);
                if (bundle != null) {
                    if (bundle.getState() != 32) {
                        this.start(bundle);
                    } else {
                        LOGGER.log(3, "Startup required bundle: '" + bundleName + "' already started.");
                    }
                } else {
                    LOGGER.log(2, "Startup required bundle: '" + bundleName + "' not found.");
                }
            }
            ++n2;
        }
    }

    private void start(Bundle bundle) throws BundleException {
        if (bundle == null) {
            return;
        }
        try {
            bundle.start();
            LOGGER.log(3, "Startup: '" + bundle.getSymbolicName() + "' succesful.");
        }
        catch (RuntimeException rte) {
            LOGGER.log(1, "Startup: '" + bundle.getSymbolicName() + "' failed with exception.", (Throwable)rte);
        }
    }

    @InjectExtension
    public void update(IRienaStartupExtension[] startups) {
        this.startups = startups;
    }
}

