/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.injector.extension;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.injector.extension.CreateLazy;
import org.eclipse.riena.core.injector.extension.DefaultValue;
import org.eclipse.riena.core.injector.extension.DoNotReplaceSymbols;
import org.eclipse.riena.core.injector.extension.DoNotWireExecutable;
import org.eclipse.riena.core.injector.extension.ExtensionInterface;
import org.eclipse.riena.core.injector.extension.MapContent;
import org.eclipse.riena.core.injector.extension.MapName;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.injector.extension.LazyExecutableExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

final class InterfaceBeanHandler
implements InvocationHandler {
    private final Class<?> interfaceType;
    private final IConfigurationElement configurationElement;
    private final boolean symbolReplace;
    private final Map<Method, Result> resolved;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), InterfaceBeanHandler.class);

    InterfaceBeanHandler(Class<?> interfaceType, boolean symbolReplace, IConfigurationElement configurationElement) {
        this.interfaceType = interfaceType;
        this.configurationElement = configurationElement;
        this.symbolReplace = symbolReplace && !interfaceType.isAnnotationPresent(DoNotReplaceSymbols.class);
        this.resolved = new HashMap<Method, Result>();
        if (!interfaceType.isAnnotationPresent(ExtensionInterface.class)) {
            LOGGER.log(2, "The interface '" + interfaceType.getName() + "' is NOT annotated with @" + ExtensionInterface.class.getSimpleName() + " but it should!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodKind methodKind = MethodKind.of(method);
        Map<Method, Result> map = this.resolved;
        synchronized (map) {
            Result result = this.resolved.get(method);
            if (result == null && (result = this.invoke(method, args, methodKind)).cacheIt) {
                this.resolved.put(method, result);
            }
            return result.object;
        }
    }

    private Result invoke(Method method, Object[] args, MethodKind methodKind) throws Throwable {
        boolean wire;
        if (method.getParameterTypes().length == 0) {
            if (method.getName().equals("toString")) {
                return Result.cache(this.proxiedToString());
            }
            if (method.getName().equals("hashCode")) {
                return Result.cache(this.proxiedHashCode());
            }
        }
        if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class && method.getName().equals("equals")) {
            return Result.noCache(this.proxiedEquals(args[0]));
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Bundle.class) {
            return Result.cache(ContributorFactoryOSGi.resolve((IContributor)this.configurationElement.getContributor()));
        }
        if (returnType == IConfigurationElement.class) {
            return Result.cache(this.configurationElement);
        }
        String attributeName = this.getAttributeName(method, methodKind);
        if (returnType == String.class) {
            boolean methodSymbolReplace = !method.isAnnotationPresent(DoNotReplaceSymbols.class);
            return Result.noCache(this.modify(method.isAnnotationPresent(MapContent.class) ? this.configurationElement.getValue() : this.getAttribute(attributeName, method), methodSymbolReplace));
        }
        if (returnType.isPrimitive()) {
            boolean methodSymbolReplace = !method.isAnnotationPresent(DoNotReplaceSymbols.class);
            return Result.noCache(this.coerce(returnType, this.modify(this.getAttribute(attributeName, method), methodSymbolReplace)));
        }
        if (returnType == Class.class) {
            String value = this.configurationElement.getAttribute(attributeName);
            if (value == null) {
                return Result.CACHED_NULL;
            }
            Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)this.configurationElement.getContributor());
            if (bundle == null) {
                return Result.CACHED_NULL;
            }
            int colon = value.indexOf(58);
            if (colon != -1) {
                value = value.substring(0, colon);
            }
            return Result.cache(this.loadClass(bundle, value));
        }
        if (returnType.isEnum()) {
            String value = this.configurationElement.getAttribute(attributeName);
            if (StringUtils.isEmpty(value)) {
                return Result.CACHED_NULL;
            }
            ?[] objArray = returnType.getEnumConstants();
            int n = objArray.length;
            int colon = 0;
            while (colon < n) {
                Object enumConstant = objArray[colon];
                if (enumConstant.toString().equalsIgnoreCase(value)) {
                    return Result.cache(enumConstant);
                }
                ++colon;
            }
            throw new IllegalStateException("Invalid enum value '" + value + "' for enum type '" + returnType.getName() + "'" + this.within());
        }
        if (returnType.isInterface() && returnType.isAnnotationPresent(ExtensionInterface.class)) {
            IConfigurationElement[] cfgElements = this.configurationElement.getChildren(attributeName);
            if (cfgElements.length == 0) {
                return Result.CACHED_NULL;
            }
            if (cfgElements.length == 1) {
                return Result.cache(Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, (InvocationHandler)new InterfaceBeanHandler(returnType, this.symbolReplace, cfgElements[0])));
            }
            throw new IllegalStateException("Got more than one configuration element but the interface expected exactly one, .i.e no array type has been specified for method '" + method + "'" + this.within());
        }
        if (returnType.isArray() && returnType.getComponentType().isInterface()) {
            IConfigurationElement[] cfgElements = this.configurationElement.getChildren(attributeName);
            Object[] result = (Object[])Array.newInstance(returnType.getComponentType(), cfgElements.length);
            int i = 0;
            while (i < cfgElements.length) {
                result[i] = Proxy.newProxyInstance(returnType.getComponentType().getClassLoader(), new Class[]{returnType.getComponentType()}, (InvocationHandler)new InterfaceBeanHandler(returnType.getComponentType(), this.symbolReplace, cfgElements[i]));
                ++i;
            }
            return Result.cache(result);
        }
        if (returnType == Void.class || args != null && args.length > 0) {
            throw new UnsupportedOperationException("Can not handle method '" + method + "'" + this.within());
        }
        if (this.configurationElement.getAttribute(attributeName) == null && this.configurationElement.getChildren(attributeName).length == 0) {
            return Result.CACHED_NULL;
        }
        boolean bl = wire = !method.isAnnotationPresent(DoNotWireExecutable.class) && !Boolean.getBoolean("riena.extensions.donotwire");
        if (method.isAnnotationPresent(CreateLazy.class)) {
            return Result.noCache(LazyExecutableExtension.newInstance(returnType, this.configurationElement, attributeName, wire));
        }
        Object result = this.configurationElement.createExecutableExtension(attributeName);
        if (wire) {
            Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)this.configurationElement.getContributor());
            BundleContext context = null;
            if (bundle != null) {
                context = bundle.getBundleContext();
            }
            if (context == null) {
                context = Activator.getDefault().getContext();
            }
            Wire.instance(result).andStart(context);
        }
        return Result.noCache(result);
    }

    private String within() {
        return " with in interface '" + this.interfaceType.getName() + "' and bundle '" + ContributorFactoryOSGi.resolve((IContributor)this.configurationElement.getContributor()) + "'";
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> loadClass(Bundle bundle, String className) throws ClassNotFoundException {
        try {
            return bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            hosts = Platform.getHosts((Bundle)bundle);
            if (hosts == null) {
                throw e;
            }
            var8_5 = hosts;
            var7_6 = hosts.length;
            var6_7 = 0;
            ** while (var6_7 < var7_6)
        }
lbl-1000:
        // 1 sources

        {
            host = var8_5[var6_7];
            try {
                return host.loadClass(className);
            }
            catch (ClassNotFoundException v0) {
                Nop.reason("try next host");
                ++var6_7;
            }
            continue;
        }
lbl18:
        // 1 sources

        throw e;
    }

    public boolean proxiedEquals(Object obj) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(obj);
            if (handler instanceof InterfaceBeanHandler) {
                return this.configurationElement.equals((Object)((InterfaceBeanHandler)handler).configurationElement);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return false;
    }

    public int proxiedHashCode() {
        return this.configurationElement.hashCode();
    }

    public String proxiedToString() {
        String[] names;
        StringBuilder bob = new StringBuilder("Dynamic proxy for ");
        bob.append(this.interfaceType.getName()).append(':');
        String[] stringArray = names = this.configurationElement.getAttributeNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            bob.append(name).append('=').append(this.configurationElement.getAttribute(name)).append(',');
            ++n2;
        }
        bob.setLength(bob.length() - 1);
        return bob.toString();
    }

    private String getAttributeName(Method method, MethodKind methodKind) {
        MapName annotation = method.getAnnotation(MapName.class);
        if (annotation != null) {
            return annotation.value();
        }
        if (methodKind == MethodKind.OTHER) {
            return null;
        }
        String name = method.getName().substring(methodKind.prefix.length());
        return String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
    }

    private String getAttribute(String attributeName, Method method) {
        String value = this.configurationElement.getAttribute(attributeName);
        if (value != null) {
            return value;
        }
        DefaultValue annotation = method.getAnnotation(DefaultValue.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    private Object coerce(Class<?> toType, String value) {
        if (toType == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (toType == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (toType == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (toType == Float.TYPE) {
            return Float.valueOf(value);
        }
        if (toType == Double.TYPE) {
            return Double.valueOf(value);
        }
        if (toType == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (toType == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (toType == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        return value;
    }

    private String modify(String value, boolean methodSymbolReplace) {
        if (!this.symbolReplace || !methodSymbolReplace || value == null) {
            return value;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        if (variableManager == null) {
            return value;
        }
        try {
            return variableManager.performStringSubstitution(value);
        }
        catch (CoreException e) {
            LOGGER.log(1, "Could not perfrom string substitution for '" + value + "' .", (Throwable)e);
            return value;
        }
    }

    static enum MethodKind {
        GET("get"),
        IS("is"),
        CREATE("create"),
        OTHER;

        private final String prefix;

        private MethodKind(String kind) {
            this.prefix = kind;
        }

        private MethodKind() {
            this.prefix = null;
        }

        private static MethodKind of(Method method) {
            String name = method.getName();
            if (name.startsWith(MethodKind.GET.prefix)) {
                return GET;
            }
            if (name.startsWith(MethodKind.IS.prefix)) {
                return IS;
            }
            if (name.startsWith(MethodKind.CREATE.prefix)) {
                return CREATE;
            }
            return OTHER;
        }

        public String toString() {
            return this.prefix;
        }
    }

    private static final class Result {
        private final Object object;
        private final boolean cacheIt;
        private static final Result CACHED_NULL = Result.cache(null);

        private static Result noCache(Object object) {
            return new Result(object, false);
        }

        private static Result cache(Object object) {
            return new Result(object, true);
        }

        private Result(Object object, boolean cacheIt) {
            this.object = object;
            this.cacheIt = cacheIt;
        }
    }
}

