/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.logging;

public final class LogLevelMapper {
    private static final String CUSTOM = "CUSTOM";
    private static final String NONE = "NONE";
    private static final String ERROR = "ERROR";
    private static final String WARN = "WARNING";
    private static final String INFO = "INFO";
    private static final String DEBUG = "DEBUG";

    private LogLevelMapper() {
    }

    public static int getValue(String logLevelString) {
        if (DEBUG.equals(logLevelString = logLevelString.toUpperCase())) {
            return 4;
        }
        if (INFO.equals(logLevelString)) {
            return 3;
        }
        if (WARN.equals(logLevelString)) {
            return 2;
        }
        if (ERROR.equals(logLevelString)) {
            return 1;
        }
        if (NONE.equals(logLevelString)) {
            return 0;
        }
        if (logLevelString.startsWith(CUSTOM)) {
            int open = logLevelString.indexOf(40);
            int close = logLevelString.indexOf(41);
            if (open != -1 && close != -1 && open < close) {
                String level = logLevelString.substring(open + 1, close).trim();
                try {
                    return Integer.parseInt(level);
                }
                catch (NumberFormatException numberFormatException) {
                    return 2;
                }
            }
        }
        return 2;
    }

    public static String getValue(int logLevel) {
        switch (logLevel) {
            case 4: {
                return DEBUG;
            }
            case 3: {
                return INFO;
            }
            case 2: {
                return WARN;
            }
            case 1: {
                return ERROR;
            }
            case 0: {
                return NONE;
            }
        }
        return "CUSTOM(" + logLevel + ')';
    }
}

