/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.logging;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.logging.CommandProviderLogFilter;
import org.eclipse.riena.core.logging.ILogCatcher;
import org.eclipse.riena.core.logging.LogServiceLogCatcher;
import org.eclipse.riena.core.logging.PlatformLogCatcher;
import org.eclipse.riena.core.logging.SynchronousLogListenerAdapter;
import org.eclipse.riena.core.logging.SysoLogListener;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.internal.core.logging.ILogCatcherExtension;
import org.eclipse.riena.internal.core.logging.ILogListenerExtension;
import org.osgi.service.log.LogListener;

public class LoggerMill {
    private final List<LogListener> logListeners = new ArrayList<LogListener>();
    private final List<ILogCatcher> logCatchers = new ArrayList<ILogCatcher>();
    private ILogListenerExtension[] listenerDefs;
    private ILogCatcherExtension[] catcherDefs;
    private ExtendedLogService logService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String category) {
        LoggerMill loggerMill = this;
        synchronized (loggerMill) {
            return this.isReady() ? this.logService.getLogger(category) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectService(useRanking=true, order=1)
    public void bind(ExtendedLogService logService) {
        LoggerMill loggerMill = this;
        synchronized (loggerMill) {
            this.logService = logService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(ExtendedLogService logService) {
        LoggerMill loggerMill = this;
        synchronized (loggerMill) {
            this.logService = null;
        }
    }

    @InjectService(useRanking=true, order=1)
    public void bind(ExtendedLogReaderService logReaderService) {
        boolean useDefaultLogging = RienaStatus.isDevelopment();
        if (this.listenerDefs.length == 0 && useDefaultLogging) {
            this.listenerDefs = new ILogListenerExtension[]{new SysoLogListenerDefinition()};
        }
        Object[] objectArray = this.listenerDefs;
        int n = this.listenerDefs.length;
        int n2 = 0;
        while (n2 < n) {
            ILogListenerExtension logListenerDef = objectArray[n2];
            Object listener = logListenerDef.createLogListener();
            if (listener != null) {
                if (logListenerDef.isSynchronous()) {
                    listener = new SynchronousLogListenerAdapter((LogListener)listener);
                }
                this.logListeners.add((LogListener)listener);
                LogFilter filter = logListenerDef.createLogFilter();
                if (filter == null) {
                    logReaderService.addLogListener(listener);
                } else {
                    logReaderService.addLogListener(listener, filter);
                }
            }
            ++n2;
        }
        if (this.catcherDefs.length == 0 && useDefaultLogging) {
            this.catcherDefs = new ILogCatcherExtension[]{new PlatformLogCatcherDefinition(), new LogServiceLogCatcherDefinition()};
        }
        objectArray = this.catcherDefs;
        n = this.catcherDefs.length;
        n2 = 0;
        while (n2 < n) {
            Object catcherDef = objectArray[n2];
            ILogCatcher logCatcher = catcherDef.createLogCatcher();
            logCatcher.attach();
            this.logCatchers.add(logCatcher);
            ++n2;
        }
    }

    public void unbind(ExtendedLogReaderService logReaderService) {
        for (LogListener logListener : this.logListeners) {
            logReaderService.removeLogListener(logListener);
        }
        for (ILogCatcher logCatcher : this.logCatchers) {
            logCatcher.detach();
        }
    }

    @InjectExtension(order=0)
    public void update(ILogListenerExtension[] listenerDefs) {
        this.listenerDefs = listenerDefs;
    }

    @InjectExtension(order=0)
    public void update(ILogCatcherExtension[] catcherDefs) {
        this.catcherDefs = catcherDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        LoggerMill loggerMill = this;
        synchronized (loggerMill) {
            return this.logService != null;
        }
    }

    private static final class LogServiceLogCatcherDefinition
    implements ILogCatcherExtension {
        private LogServiceLogCatcherDefinition() {
        }

        @Override
        public ILogCatcher createLogCatcher() {
            return new LogServiceLogCatcher();
        }

        @Override
        public String getName() {
            return "DefaultLogServiceLogCatcher";
        }
    }

    private static final class PlatformLogCatcherDefinition
    implements ILogCatcherExtension {
        private PlatformLogCatcherDefinition() {
        }

        @Override
        public ILogCatcher createLogCatcher() {
            return new PlatformLogCatcher();
        }

        @Override
        public String getName() {
            return "DefaultPlatformLogCatcher";
        }
    }

    private static final class SysoLogListenerDefinition
    implements ILogListenerExtension {
        private SysoLogListenerDefinition() {
        }

        @Override
        public boolean isSynchronous() {
            return true;
        }

        @Override
        public LogFilter createLogFilter() {
            return new CommandProviderLogFilter();
        }

        @Override
        public LogListener createLogListener() {
            return new SysoLogListener();
        }

        @Override
        public String getName() {
            return "DefaultLogListner";
        }
    }
}

