/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.exception;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.e4.launcher.Activator;

public class E4UncaughtExceptionHandler
extends StatusReporter
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = Log4r.getLogger(E4UncaughtExceptionHandler.class);
    private IExceptionHandlerManager exceptionHanderManager;

    public E4UncaughtExceptionHandler install() {
        Thread.setDefaultUncaughtExceptionHandler(this);
        return this;
    }

    @InjectService
    public void bind(IExceptionHandlerManager exceptionHanderManager) {
        this.exceptionHanderManager = exceptionHanderManager;
    }

    public void unbind(IExceptionHandlerManager exceptionHanderManager) {
        if (this.exceptionHanderManager == exceptionHanderManager) {
            this.exceptionHanderManager = null;
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.handleException(throwable);
    }

    public void handleException(Throwable throwable) {
        if (this.exceptionHanderManager == null) {
            return;
        }
        this.exceptionHanderManager.handleException(throwable);
    }

    public void report(IStatus status, int style, Object ... information) {
        Throwable throwable = status.getException();
        if (throwable != null) {
            this.handleException(throwable);
        } else if (!status.isOK()) {
            LOGGER.log(2, "Status was not OK, but there was no exception: " + status);
        }
    }

    public IStatus newStatus(int severity, String message, Throwable exception) {
        return new Status(severity, Activator.PLUGIN_ID, message, exception);
    }
}

