/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.riena.e4.launcher.part.MenuHelper;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.menus.DynamicMenuContributionItem;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.services.IServiceLocator;

public class MenuAdditionCacheEntry {
    static final String MAIN_TOOLBAR = "org.eclipse.ui.main.toolbar";
    static final String TRIM_COMMAND1 = "org.eclipse.ui.trim.command1";
    static final String TRIM_COMMAND2 = "org.eclipse.ui.trim.command2";
    static final String TRIM_VERTICAL1 = "org.eclipse.ui.trim.vertical1";
    static final String TRIM_VERTICAL2 = "org.eclipse.ui.trim.vertical2";
    static final String TRIM_STATUS = "org.eclipse.ui.trim.status";
    private final MApplication application;
    private final IConfigurationElement configElement;
    private final MenuLocationURI location;
    private final String namespaceIdentifier;
    private final IdListener idUpdater = new IdListener();

    static boolean isInWorkbenchTrim(MenuLocationURI location) {
        String path = location.getPath();
        return MAIN_TOOLBAR.equals(path) || TRIM_COMMAND1.equals(path) || TRIM_COMMAND2.equals(path) || TRIM_VERTICAL1.equals(path) || TRIM_VERTICAL2.equals(path) || TRIM_STATUS.equals(path);
    }

    public MenuAdditionCacheEntry(MApplication application, IEclipseContext appContext, IConfigurationElement configElement, String attribute, String namespaceIdentifier) {
        this.application = application;
        assert (appContext.equals(this.application.getContext()));
        this.configElement = configElement;
        this.location = new MenuLocationURI(attribute);
        this.namespaceIdentifier = namespaceIdentifier;
    }

    private boolean inToolbar() {
        return this.location.getScheme().startsWith("toolbar");
    }

    public void mergeIntoModel(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IConfigurationElement[] menus;
        if ("menu:help?after=additions".equals(this.location.toString()) && (menus = this.configElement.getChildren("menu")).length == 1 && "org.eclipse.update.ui.updateMenu".equals(MenuHelper.getId(menus[0]))) {
            return;
        }
        if (this.location.getPath() == null || this.location.getPath().length() == 0) {
            WorkbenchPlugin.log((String)("MenuAdditionCacheEntry.mergeIntoModel: Invalid menu URI: " + this.location));
            return;
        }
        if (this.inToolbar()) {
            if (MenuAdditionCacheEntry.isInWorkbenchTrim(this.location)) {
                this.processTrimChildren(trimContributions, toolBarContributions, this.configElement);
            } else {
                String query = this.location.getQuery();
                if (query == null || query.length() == 0) {
                    query = "after=additions";
                }
                this.processToolbarChildren(toolBarContributions, this.configElement, this.location.getPath(), query);
            }
            return;
        }
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        String idContrib = MenuHelper.getId(this.configElement);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(idContrib);
        }
        if ("org.eclipse.ui.popup.any".equals(this.location.getPath())) {
            menuContribution.setParentId("popup");
        } else {
            menuContribution.setParentId(this.location.getPath());
        }
        String query = this.location.getQuery();
        if (query == null || query.length() == 0) {
            query = "after=additions";
        }
        menuContribution.setPositionInParent(query);
        menuContribution.getTags().add("scheme:" + this.location.getScheme());
        String filter = "menuContribution:menu";
        if ("popup".equals(this.location.getScheme())) {
            filter = "menuContribution:popup";
        }
        menuContribution.getTags().add(filter);
        menuContribution.setVisibleWhen(MenuHelper.getVisibleWhen(this.configElement));
        this.addMenuChildren((MElementContainer<MMenuElement>)menuContribution, this.configElement, filter);
        menuContributions.add(menuContribution);
        this.processMenuChildren(menuContributions, this.configElement, filter);
    }

    private void processMenuChildren(ArrayList<MMenuContribution> menuContributions, IConfigurationElement element, String filter) {
        IConfigurationElement[] menus = element.getChildren("menu");
        if (menus.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement menu = iConfigurationElementArray[n2];
            MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
            String idContrib = MenuHelper.getId(menu);
            if (idContrib != null && idContrib.length() > 0) {
                menuContribution.setElementId(idContrib);
            }
            menuContribution.setParentId(idContrib);
            menuContribution.setPositionInParent("after=additions");
            menuContribution.getTags().add("scheme:" + this.location.getScheme());
            menuContribution.getTags().add(filter);
            menuContribution.setVisibleWhen(MenuHelper.getVisibleWhen(menu));
            this.addMenuChildren((MElementContainer<MMenuElement>)menuContribution, menu, filter);
            menuContributions.add(menuContribution);
            this.processMenuChildren(menuContributions, menu, filter);
            ++n2;
        }
    }

    private void addMenuChildren(MElementContainer<MMenuElement> container, IConfigurationElement parent, String filter) {
        IConfigurationElement[] items;
        IConfigurationElement[] iConfigurationElementArray = items = parent.getChildren();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MMenuElement element;
            final IConfigurationElement child = iConfigurationElementArray[n2];
            String itemType = child.getName();
            String id = MenuHelper.getId(child);
            if ("command".equals(itemType)) {
                element = this.createMenuCommandAddition(child);
                container.getChildren().add(element);
            } else if ("separator".equals(itemType)) {
                element = this.createMenuSeparatorAddition(child);
                container.getChildren().add(element);
            } else if ("menu".equals(itemType)) {
                element = this.createMenuAddition(child, filter);
                container.getChildren().add(element);
            } else if ("toolbar".equals(itemType)) {
                System.out.println("Toolbar: " + id + " in " + this.location);
            } else if ("dynamic".equals(itemType)) {
                ContextFunction generator = new ContextFunction(){

                    public Object compute(IEclipseContext context, String contextKey) {
                        ServiceLocator sl = new ServiceLocator();
                        sl.setContext(context);
                        DynamicMenuContributionItem item = new DynamicMenuContributionItem(MenuHelper.getId(child), (IServiceLocator)sl, child);
                        return item;
                    }
                };
                MRenderedMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createRenderedMenuItem();
                menuItem.setElementId(id);
                menuItem.setContributionItem((Object)generator);
                menuItem.setVisibleWhen(MenuHelper.getVisibleWhen(child));
                container.getChildren().add(menuItem);
            }
            ++n2;
        }
    }

    private MMenuElement createMenuCommandAddition(IConfigurationElement commandAddition) {
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.setElementId(MenuHelper.getId(commandAddition));
        String commandId = MenuHelper.getCommandId(commandAddition);
        MCommand commandById = ContributionsAnalyzer.getCommandById((MApplication)this.application, (String)commandId);
        if (commandById == null) {
            commandById = CommandsFactoryImpl.eINSTANCE.createCommand();
            commandById.setElementId(commandId);
            commandById.setCommandName(commandId);
            this.application.getCommands().add(commandById);
        }
        item.setCommand(commandById);
        Map<String, String> parms = MenuHelper.getParameters(commandAddition);
        Iterator<Map.Entry<String, String>> iterator = parms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> obj;
            Map.Entry<String, String> e = obj = iterator.next();
            MParameter parm = CommandsFactoryImpl.eINSTANCE.createParameter();
            parm.setName(e.getKey().toString());
            parm.setValue(e.getValue().toString());
            item.getParameters().add(parm);
        }
        String iconUrl = MenuHelper.getIconURI(commandAddition, "icon");
        if (iconUrl == null) {
            ImageDescriptor descriptor;
            ICommandImageService commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class);
            ImageDescriptor imageDescriptor = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(commandId);
            if (descriptor == null) {
                ImageDescriptor imageDescriptor2 = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(item.getElementId());
            }
            if (descriptor != null) {
                item.setIconURI(MenuHelper.getImageUrl(descriptor));
            }
        } else {
            item.setIconURI(iconUrl);
        }
        item.setLabel(MenuHelper.getLabel(commandAddition));
        item.setMnemonics(MenuHelper.getMnemonic(commandAddition));
        item.setTooltip(MenuHelper.getTooltip(commandAddition));
        item.setType(MenuHelper.getStyle(commandAddition));
        item.setVisibleWhen(MenuHelper.getVisibleWhen(commandAddition));
        this.createIdentifierTracker((MApplicationElement)item);
        return item;
    }

    private void createIdentifierTracker(MApplicationElement item) {
        if (item.getElementId() != null && item.getElementId().length() > 0) {
            String id = String.valueOf(this.namespaceIdentifier) + "/" + item.getElementId();
            item.getPersistedState().put("IIdentifier", id);
        }
    }

    private MMenuElement createMenuSeparatorAddition(IConfigurationElement sepAddition) {
        String name = MenuHelper.getName(sepAddition);
        MMenuSeparator element = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        element.setElementId(name);
        if (!MenuHelper.isSeparatorVisible(sepAddition)) {
            element.setVisible(false);
            element.getTags().add("org.eclipse.jface.action.GroupMarker.GroupMarker(String)");
        }
        return element;
    }

    private MMenu createMenuAddition(IConfigurationElement menuAddition, String filter) {
        if (this.inToolbar()) {
            return null;
        }
        MMenu menu = MenuHelper.createMenuAddition(menuAddition);
        menu.getTags().add(filter);
        return menu;
    }

    private boolean isUndefined(String query) {
        if (query == null || query.length() == 0) {
            return true;
        }
        int index = query.indexOf(61);
        return index == -1 || query.substring(index + 1).equals("additions");
    }

    private void processTrimLocation(MTrimContribution contribution) {
        String query = this.location.getQuery();
        if (TRIM_COMMAND2.equals(this.location.getPath())) {
            contribution.setParentId(MAIN_TOOLBAR);
            if (this.isUndefined(query)) {
                query = "endof";
            }
            contribution.setPositionInParent(query);
        } else {
            contribution.setParentId(this.location.getPath());
            if (query == null || query.length() == 0) {
                query = "after=additions";
            }
            contribution.setPositionInParent(query);
        }
    }

    private void processTrimChildren(ArrayList<MTrimContribution> trimContributions, ArrayList<MToolBarContribution> toolBarContributions, IConfigurationElement element) {
        IConfigurationElement[] toolbars = element.getChildren("toolbar");
        if (toolbars.length == 0) {
            return;
        }
        MTrimContribution trimContribution = MenuFactoryImpl.eINSTANCE.createTrimContribution();
        String idContrib = MenuHelper.getId(this.configElement);
        if (idContrib != null && idContrib.length() > 0) {
            trimContribution.setElementId(idContrib);
        }
        this.processTrimLocation(trimContribution);
        trimContribution.getTags().add("scheme:" + this.location.getScheme());
        IConfigurationElement[] iConfigurationElementArray = toolbars;
        int n = toolbars.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement toolbar = iConfigurationElementArray[n2];
            MToolBar item = MenuFactoryImpl.eINSTANCE.createToolBar();
            item.setElementId(MenuHelper.getId(toolbar));
            item.getTransientData().put("Name", MenuHelper.getLabel(toolbar));
            this.processToolbarChildren(toolBarContributions, toolbar, item.getElementId(), "after=additions");
            trimContribution.getChildren().add(item);
            ++n2;
        }
        trimContributions.add(trimContribution);
    }

    private void processToolbarChildren(ArrayList<MToolBarContribution> contributions, IConfigurationElement toolbar, String parentId, String position) {
        IConfigurationElement[] items;
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        String idContrib = MenuHelper.getId(toolbar);
        if (idContrib != null && idContrib.length() > 0) {
            toolBarContribution.setElementId(idContrib);
        }
        toolBarContribution.setParentId(parentId);
        toolBarContribution.setPositionInParent(position);
        toolBarContribution.getTags().add("scheme:" + this.location.getScheme());
        IConfigurationElement[] iConfigurationElementArray = items = toolbar.getChildren();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBarElement element;
            IConfigurationElement item = iConfigurationElementArray[n2];
            String itemType = item.getName();
            if ("command".equals(itemType)) {
                element = this.createToolBarCommandAddition(item);
                toolBarContribution.getChildren().add(element);
            } else if ("separator".equals(itemType)) {
                element = this.createToolBarSeparatorAddition(item);
                toolBarContribution.getChildren().add(element);
            } else if ("control".equals(itemType)) {
                element = this.createToolControlAddition(item);
                toolBarContribution.getChildren().add(element);
            }
            ++n2;
        }
        contributions.add(toolBarContribution);
    }

    private MToolBarElement createToolControlAddition(IConfigurationElement element) {
        String id = MenuHelper.getId(element);
        MToolControl control = MenuFactoryImpl.eINSTANCE.createToolControl();
        control.setElementId(id);
        control.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.menus.CompatibilityWorkbenchWindowControlContribution");
        ControlContributionRegistry.add((String)id, (IConfigurationElement)element);
        control.setVisibleWhen(MenuHelper.getVisibleWhen(element));
        this.createIdentifierTracker((MApplicationElement)control);
        return control;
    }

    private MToolBarElement createToolBarSeparatorAddition(IConfigurationElement sepAddition) {
        String name = MenuHelper.getName(sepAddition);
        MToolBarSeparator element = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        element.setElementId(name);
        if (!MenuHelper.isSeparatorVisible(sepAddition)) {
            element.setToBeRendered(false);
            element.setVisible(false);
            element.getTags().add("org.eclipse.jface.action.GroupMarker.GroupMarker(String)");
        }
        return element;
    }

    private MToolBarElement createToolBarCommandAddition(IConfigurationElement commandAddition) {
        ImageDescriptor descriptor;
        ICommandImageService commandImageService;
        MHandledToolItem item = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        item.setElementId(MenuHelper.getId(commandAddition));
        String commandId = MenuHelper.getCommandId(commandAddition);
        MCommand commandById = ContributionsAnalyzer.getCommandById((MApplication)this.application, (String)commandId);
        if (commandById == null) {
            commandById = CommandsFactoryImpl.eINSTANCE.createCommand();
            commandById.setElementId(commandId);
            commandById.setCommandName(commandId);
            this.application.getCommands().add(commandById);
        }
        item.setCommand(commandById);
        Map<String, String> parms = MenuHelper.getParameters(commandAddition);
        Iterator<Map.Entry<String, String>> iterator = parms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> obj;
            Map.Entry<String, String> e = obj = iterator.next();
            MParameter parm = CommandsFactoryImpl.eINSTANCE.createParameter();
            parm.setName(e.getKey().toString());
            parm.setValue(e.getValue().toString());
            item.getParameters().add(parm);
        }
        String iconUrl = MenuHelper.getIconURI(commandAddition, "icon");
        if (iconUrl == null) {
            commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class);
            ImageDescriptor imageDescriptor = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(commandId, "toolbar");
            if (descriptor == null) {
                ImageDescriptor imageDescriptor2 = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(item.getElementId(), "toolbar");
                if (descriptor == null) {
                    item.setLabel(MenuHelper.getLabel(commandAddition));
                } else {
                    item.setIconURI(MenuHelper.getImageUrl(descriptor));
                }
            } else {
                item.setIconURI(MenuHelper.getImageUrl(descriptor));
            }
        } else {
            item.setIconURI(iconUrl);
        }
        iconUrl = MenuHelper.getIconURI(commandAddition, "disabledIcon");
        if (iconUrl == null && (commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class)) != null) {
            descriptor = commandImageService.getImageDescriptor(commandId, 1, "toolbar");
            if (descriptor == null) {
                descriptor = commandImageService.getImageDescriptor(item.getElementId(), 1, "toolbar");
            }
            if (descriptor != null) {
                iconUrl = MenuHelper.getImageUrl(descriptor);
            }
        }
        if (iconUrl != null) {
            MenuHelper.setDisabledIconURI((MToolItem)item, iconUrl);
        }
        item.setTooltip(MenuHelper.getTooltip(commandAddition));
        item.setType(MenuHelper.getStyle(commandAddition));
        if (MenuHelper.hasPulldownStyle(commandAddition)) {
            MMenu element = MenuFactoryImpl.eINSTANCE.createMenu();
            String id = MenuHelper.getId(commandAddition);
            element.setElementId(id);
            item.setMenu(element);
        }
        item.setVisibleWhen(MenuHelper.getVisibleWhen(commandAddition));
        this.createIdentifierTracker((MApplicationElement)item);
        return item;
    }

    private class IdListener
    implements IIdentifierListener {
        private IdListener() {
        }

        public void identifierChanged(IdentifierEvent identifierEvent) {
            MenuAdditionCacheEntry.this.application.getContext().set(identifierEvent.getIdentifier().getId(), (Object)identifierEvent.getIdentifier().isEnabled());
        }
    }
}

