/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.riena.e4.launcher.Activator;
import org.eclipse.riena.e4.launcher.part.PartWrapper;
import org.eclipse.riena.e4.launcher.part.ViewInstanceProvider;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RienaPartHelper {
    public static final String COMPOUND_ID_DELIMITER = ":";
    public static final String COUNTER_DELIMITER = "#";
    private static final String KEY_E4_PART_ID = "E4PartId";
    @Inject
    private IEclipseContext context;
    @Inject
    private EModelService modelService;
    private static int secondaryIdCounter = 0;

    public void showPart(ISubModuleNode source) {
        String partId = (String)source.getContext(KEY_E4_PART_ID);
        MPart partToActivate = null;
        if (partId == null) {
            partToActivate = this.createPart(source);
        } else {
            partToActivate = this.findPart(source);
            Object viewInstance = partToActivate.getTransientData().get(PartWrapper.VIEW_KEY);
            if (viewInstance instanceof SubModuleView) {
                ((SubModuleView)viewInstance).setNavigationNode(source);
                ((SubModuleView)viewInstance).prepareNode(source);
            }
        }
        if (partToActivate == null) {
            throw new IllegalStateException("Part not found, partId: " + partId);
        }
        partToActivate.getParent().setSelectedElement((MUIElement)partToActivate);
    }

    private MPart findPart(ISubModuleNode node) {
        String partId = (String)node.getContext(KEY_E4_PART_ID);
        if (partId == null) {
            return null;
        }
        List parts = this.modelService.findElements((MUIElement)this.context.get(MApplication.class), partId, MPart.class, null, 4);
        return (MPart)parts.get(0);
    }

    private MPart createPart(ISubModuleNode source) {
        ISubApplicationNode subApplicationNode = (ISubApplicationNode)source.getParentOfType(ISubApplicationNode.class);
        MPartStack parent = this.findStackPart(subApplicationNode);
        MPart partToActivate = MBasicFactory.INSTANCE.createPart();
        String partId = this.createPartId(source);
        partToActivate.setElementId(partId);
        source.setContext(KEY_E4_PART_ID, (Object)partId);
        String pluginId = Activator.getDefault().getBundleContext().getBundle().getSymbolicName();
        partToActivate.setContributionURI("bundleclass://" + pluginId + "/" + PartWrapper.class.getName());
        parent.getChildren().add(partToActivate);
        partToActivate.setParent((MElementContainer)parent);
        return partToActivate;
    }

    private MPartStack findStackPart(ISubApplicationNode subApplicationNode) {
        String perspectiveId = SwtViewProvider.getInstance().getSwtViewId((INavigationNode)subApplicationNode).getId();
        List perspectives = this.modelService.findElements((MUIElement)this.context.get(MApplication.class), perspectiveId, MPerspective.class, null);
        if (perspectives.isEmpty()) {
            throw new IllegalStateException("Parent perspective not found. perspectiveId: " + perspectiveId);
        }
        MPerspective subApplicationPerspective = (MPerspective)perspectives.get(0);
        List stacks = this.modelService.findElements((MUIElement)subApplicationPerspective, "org.eclipse.riena.e4.launcher.contentPartStack", MPartStack.class, null);
        if (stacks.isEmpty()) {
            throw new IllegalStateException("Part stack not found on parent perspective. perspectiveId: " + perspectiveId);
        }
        MPartStack parent = (MPartStack)stacks.get(0);
        return parent;
    }

    private String createPartId(ISubModuleNode node) {
        String basicId = SwtViewProvider.getInstance().getSwtViewId((INavigationNode)node).getCompoundId();
        String fqId = String.valueOf(basicId) + COUNTER_DELIMITER + this.increasePartCounter();
        return fqId;
    }

    private String increasePartCounter() {
        return String.valueOf(secondaryIdCounter++);
    }

    public void disposeNode(ISubModuleNode source) {
        MPart part = this.findPart(source);
        if (part != null) {
            String typeId = RienaPartHelper.extractRienaCompoundId((MUIElement)part)[0];
            Composite widget = (Composite)part.getWidget();
            this.unregisterPart(part);
            int remainingCount = ViewInstanceProvider.getInstance().decreaseViewCounter(typeId);
            if (remainingCount == 0) {
                widget.dispose();
                ViewInstanceProvider.getInstance().unregisterParentComposite(typeId);
            }
        }
    }

    private void unregisterPart(MPart part) {
        part.setWidget(null);
        part.getParent().getChildren().remove(part);
    }

    public static String[] extractRienaCompoundId(MUIElement part) {
        return part.getElementId().split(COUNTER_DELIMITER)[0].split(COMPOUND_ID_DELIMITER);
    }

    public static boolean isSharedView(ISubModuleNode source) {
        return WorkareaManager.getInstance().getDefinition((Object)source).isViewShared();
    }

    public static IShellProvider toShellProvider(final Shell shell) {
        return new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
    }
}

