/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.e4.launcher.part;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.swt.widgets.Composite;

public class ViewInstanceProvider {
    private static final SingletonProvider<ViewInstanceProvider> UIS = new SingletonProvider(ViewInstanceProvider.class);
    private final Map<String, SubModuleView> views = new HashMap<String, SubModuleView>();
    private final Map<String, Composite> composites = new HashMap<String, Composite>();
    private final Map<String, Integer> viewUsage = new HashMap<String, Integer>();

    private ViewInstanceProvider() {
    }

    public SubModuleView getView(String typeId) {
        return this.views.get(typeId);
    }

    public Composite getParentComposite(String typeId) {
        return this.composites.get(typeId);
    }

    public void registerView(String typeId, SubModuleView view) {
        this.views.put(typeId, view);
        this.increaseViewCounter(typeId);
    }

    public int increaseViewCounter(String typeId) {
        Integer count = this.viewUsage.get(typeId);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.viewUsage.put(typeId, count);
        return count;
    }

    public int decreaseViewCounter(String typeId) {
        Integer count = this.viewUsage.get(typeId);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count - 1);
        this.viewUsage.put(typeId, count);
        return count;
    }

    public void registerParentComposite(String typeId, Composite parent) {
        this.composites.put(typeId, parent);
    }

    public void unregisterView(String typeId) {
        this.views.remove(typeId);
    }

    public void unregisterTypeId(String typeId) {
        this.unregisterParentComposite(typeId);
        this.unregisterView(typeId);
    }

    public void unregisterParentComposite(String typeId) {
        this.composites.remove(typeId);
    }

    public static ViewInstanceProvider getInstance() {
        return (ViewInstanceProvider)UIS.getInstance();
    }
}

