/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.AbstractScrollingSupport;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ScrollBarSupport
extends AbstractScrollingSupport {
    private final ScrolledComposite scrolledComposite;

    public ScrollBarSupport(ScrolledComposite scrolledComposite, IModuleNavigationComponentProvider navigationComponentProvider) {
        super(navigationComponentProvider);
        this.scrolledComposite = scrolledComposite;
    }

    @Override
    public void scroll() {
        IModuleNode activeModule = this.getActiveModule(this.getActiveNode());
        if (this.canScroll(activeModule)) {
            this.scrollTo(activeModule);
        }
    }

    private IModuleNode getActiveModule(INavigationNode<?> activeNode) {
        if (activeNode instanceof IModuleGroupNode) {
            return null;
        }
        if (activeNode instanceof IModuleNode) {
            return (IModuleNode)activeNode;
        }
        if (activeNode instanceof ISubModuleNode) {
            return (IModuleNode)activeNode.getParent();
        }
        return null;
    }

    @Override
    protected boolean scrollTo(Composite topComp, Composite bottomComp) {
        int pixels = this.getScrollPixels(topComp, bottomComp);
        if (this.canScroll(pixels)) {
            this.scroll(pixels);
            return true;
        }
        return false;
    }

    @Override
    protected boolean scrollTo(Tree tree) {
        int pixels = this.getScrollPixels(tree);
        if (this.canScroll(pixels)) {
            this.scroll(pixels);
            return true;
        }
        return false;
    }

    private boolean canScroll(IModuleNode module) {
        boolean isClosed;
        if (module == null) {
            return false;
        }
        ModuleView moduleView = this.navigationComponentProvider.getModuleViewForNode(module);
        if (moduleView == null) {
            return false;
        }
        boolean bl = isClosed = moduleView.getOpenHeight() == 0;
        if (isClosed) {
            return this.canScroll((Composite)moduleView.getTitle(), moduleView.getBody());
        }
        return this.canScroll(moduleView.getTree());
    }

    private boolean canScroll(Composite topComp, Composite bottomComp) {
        return this.canScroll(this.getScrollPixels(topComp, bottomComp));
    }

    private boolean canScroll(Tree tree) {
        return this.canScroll(this.getScrollPixels(tree));
    }

    private boolean canScroll(int pixels) {
        return pixels != 0;
    }

    private int getScrollPixels(Composite topComp, Composite bottomComp) {
        int ty = this.scrolledComposite.getDisplay().map((Control)topComp, (Control)this.scrolledComposite, (int)0, (int)topComp.getBounds().y).y;
        if (ty < 0) {
            return ty;
        }
        int by = this.scrolledComposite.getDisplay().map((Control)bottomComp, (Control)this.scrolledComposite, (int)0, (int)bottomComp.getBounds().height).y;
        int clientHeight = this.scrolledComposite.getClientArea().height;
        if (by > clientHeight) {
            return by - clientHeight;
        }
        return 0;
    }

    private int getScrollPixels(Tree tree) {
        if (SwtUtilities.isDisposed((Widget)tree)) {
            return 0;
        }
        if (tree.getSelectionCount() > 0) {
            TreeItem item = tree.getSelection()[0];
            Rectangle itemBounds = item.getBounds();
            int y = this.scrolledComposite.getDisplay().map((Control)tree, (Control)this.scrolledComposite, (int)0, (int)itemBounds.y).y;
            if (y < 0) {
                return y;
            }
            y = this.scrolledComposite.getDisplay().map((Control)tree, (Control)this.scrolledComposite, (int)0, (int)(itemBounds.y + itemBounds.height)).y;
            int clientHeight = this.scrolledComposite.getClientArea().height;
            if (y > clientHeight) {
                return y - clientHeight;
            }
        }
        return 0;
    }

    @Override
    protected int getNavigationComponentHeight() {
        return this.scrolledComposite.getBounds().height;
    }

    @Override
    protected void scrollUp(int pixels) {
        this.scroll(-pixels);
    }

    @Override
    protected void scrollDown(int pixels) {
        this.scroll(pixels);
    }

    private void scroll(int pixels) {
        Point origin = this.scrolledComposite.getOrigin();
        origin.y += pixels;
        this.scrolledComposite.setOrigin(origin);
    }
}

