/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.state;

public final class State {
    private static final transient int CREATED_CODE = 1;
    private static final transient int DELETED_CODE = 2;
    private static final transient int MODIFIED_CODE = 3;
    private static final transient int CLEAN_CODE = 4;
    private static final transient int VANISHED_CODE = 5;
    private static final transient int ADDED_CODE = 6;
    private static final transient int REMOVED_CODE = 7;
    public static final transient State CLEAN = new State(4);
    public static final transient State CREATED = new State(1);
    public static final transient State MODIFIED = new State(3);
    public static final transient State DELETED = new State(2);
    public static final transient State VANISHED = new State(5);
    public static final transient State ADDED = new State(6);
    public static final transient State REMOVED = new State(7);
    private final int state;

    private State(int state) {
        this.state = state;
    }

    public String toString() {
        if (this.state == 1) {
            return "created";
        }
        if (this.state == 2) {
            return "deleted";
        }
        if (this.state == 3) {
            return "modified";
        }
        if (this.state == 4) {
            return "clean (unmodified)";
        }
        if (this.state == 5) {
            return "vanished (was created and then deleted)";
        }
        if (this.state == 6) {
            return "add";
        }
        if (this.state == 7) {
            return "remove";
        }
        return "unknown state ?????";
    }

    public static String toString(State state) {
        if (state == null) {
            return "state is NULL ??";
        }
        return state.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof State) {
            return ((State)object).state == this.state;
        }
        return false;
    }

    public int hashCode() {
        return this.state;
    }
}

