/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.List;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationAssembler;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.StartupNodeInfo;
import org.eclipse.riena.navigation.extension.IModuleNode2Extension;
import org.eclipse.riena.navigation.extension.INavigationAssembly2Extension;
import org.eclipse.riena.navigation.extension.ModuleNode2Extension;
import org.eclipse.riena.navigation.extension.NavigationAssembly2Extension;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.model.GenericNavigationAssembler;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationProcessor;
import org.eclipse.riena.navigation.model.SimpleNavigationNodeProvider;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.model.TestSecondModuleGroupNodeAssembler;

@NonUITestCase
public class SimpleNavigationNodeProviderTest
extends RienaTestCase {
    private IApplicationNode applicationNode;
    private ISubApplicationNode subApplication;
    private IModuleGroupNode moduleGroup;
    private IModuleNode module;
    private ISubModuleNode subModule;

    protected void setUp() throws Exception {
        super.setUp();
        this.applicationNode = new ApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.application"));
        this.applicationNode.setNavigationProcessor((INavigationProcessor)new NavigationProcessor());
        this.subApplication = new SubApplicationNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subApplication"));
        this.applicationNode.addChild((INavigationNode)this.subApplication);
        this.moduleGroup = new ModuleGroupNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.moduleGroup"));
        this.subApplication.addChild((INavigationNode)this.moduleGroup);
        this.module = new ModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.module"));
        this.moduleGroup.addChild((INavigationNode)this.module);
        this.subModule = new SubModuleNode(new NavigationNodeId("org.eclipse.riena.navigation.model.test.subModule"));
        this.module.addChild((INavigationNode)this.subModule);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.applicationNode = null;
    }

    public void testProvideNode() {
        this.subModule.activate();
        SimpleNavigationNodeProviderTest.assertEquals((int)1, (int)this.subApplication.getChildren().size());
        SimpleNavigationNodeProviderTest.assertTrue((boolean)this.subApplication.isActivated());
        SimpleNavigationNodeProvider provider = new SimpleNavigationNodeProvider();
        TestSecondModuleGroupNodeAssembler assembler = new TestSecondModuleGroupNodeAssembler();
        provider.registerNavigationAssembler("myTestAssemberId", (INavigationAssembler)assembler);
        NavigationArgument naviArg = new NavigationArgument((Object)new Integer(4711), new NavigationNodeId("org.eclipse.riena.navigation.model.test.subApplication"));
        INavigationNode node = provider.provideNode((INavigationNode)this.subModule, new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"), naviArg);
        SimpleNavigationNodeProviderTest.assertNotNull((Object)node);
        SimpleNavigationNodeProviderTest.assertSame((Object)"org.eclipse.riena.navigation.model.test.secondModuleGroup", (Object)node.getNodeId().getTypeId());
        SimpleNavigationNodeProviderTest.assertEquals((int)2, (int)this.subApplication.getChildren().size());
        INavigationNode subModuleChild = node.getChild(0).getChild(0);
        SimpleNavigationNodeProviderTest.assertFalse((boolean)subModuleChild.isPrepared());
        SimpleNavigationNodeProviderTest.assertEquals((Object)4711, (Object)node.getNavigationArgument().getParameter());
        this.subApplication.removeChild(node);
        SimpleNavigationNodeProviderTest.assertEquals((int)1, (int)this.subApplication.getChildren().size());
        naviArg.setPrepareAll(true);
        node = provider.provideNode((INavigationNode)this.subModule, new NavigationNodeId("org.eclipse.riena.navigation.model.test.secondModuleGroup"), naviArg);
        SimpleNavigationNodeProviderTest.assertNotNull((Object)node);
        SimpleNavigationNodeProviderTest.assertSame((Object)"org.eclipse.riena.navigation.model.test.secondModuleGroup", (Object)node.getNodeId().getTypeId());
        SimpleNavigationNodeProviderTest.assertEquals((int)2, (int)this.subApplication.getChildren().size());
        subModuleChild = node.getChild(0).getChild(0);
        SimpleNavigationNodeProviderTest.assertTrue((boolean)subModuleChild.isPrepared());
        SimpleNavigationNodeProviderTest.assertEquals((Object)4711, (Object)node.getNavigationArgument().getParameter());
    }

    public void testRegister() {
        SimpleNavigationNodeProvider provider = new SimpleNavigationNodeProvider();
        NavigationAssembly2Extension assembly = new NavigationAssembly2Extension();
        assembly.setId("test4711");
        assembly.setParentNodeId("parent0815");
        assembly.setStartOrder(123);
        provider.register((INavigationAssembly2Extension)assembly);
        INavigationAssembler assembler = provider.getNavigationAssembler(assembly.getId());
        SimpleNavigationNodeProviderTest.assertTrue((boolean)(assembler instanceof GenericNavigationAssembler));
        SimpleNavigationNodeProviderTest.assertSame((Object)assembly, (Object)assembler.getAssembly());
        SimpleNavigationNodeProviderTest.assertEquals((String)"test4711", (String)assembler.getId());
        SimpleNavigationNodeProviderTest.assertEquals((String)"parent0815", (String)assembler.getParentNodeId());
        SimpleNavigationNodeProviderTest.assertEquals((int)123, (int)assembler.getStartOrder());
        provider.cleanUp();
        TestSecondModuleGroupNodeAssembler naviAssembler = new TestSecondModuleGroupNodeAssembler();
        assembly.setAssembler((INavigationAssembler)naviAssembler);
        provider.register((INavigationAssembly2Extension)assembly);
        assembler = provider.getNavigationAssembler(assembly.getId());
        SimpleNavigationNodeProviderTest.assertSame((Object)((Object)naviAssembler), (Object)assembler);
        SimpleNavigationNodeProviderTest.assertSame((Object)assembly, (Object)assembler.getAssembly());
    }

    public void testFindNode() {
        MyProvider provider = new MyProvider();
        INavigationNode<?> node = provider.findNode((INavigationNode<?>)this.applicationNode, new NavigationNodeId("org.eclipse.riena.navigation.model.test.module"));
        SimpleNavigationNodeProviderTest.assertSame((Object)this.module, node);
        node = provider.findNode((INavigationNode<?>)this.applicationNode, new NavigationNodeId("dummy"));
        SimpleNavigationNodeProviderTest.assertNull(node);
        node = provider.findNode((INavigationNode<?>)this.applicationNode, null);
        SimpleNavigationNodeProviderTest.assertNull(node);
    }

    public void testPrepareAll() {
        SimpleNavigationNodeProvider provider = new SimpleNavigationNodeProvider();
        ReflectionUtils.invokeHidden((Object)provider, (String)"prepareAll", (Object[])new Object[]{this.subApplication});
        SimpleNavigationNodeProviderTest.assertFalse((boolean)this.applicationNode.isPrepared());
        SimpleNavigationNodeProviderTest.assertTrue((boolean)this.subApplication.isPrepared());
        SimpleNavigationNodeProviderTest.assertTrue((boolean)this.moduleGroup.isPrepared());
        SimpleNavigationNodeProviderTest.assertTrue((boolean)this.module.isPrepared());
        SimpleNavigationNodeProviderTest.assertTrue((boolean)this.subModule.isPrepared());
    }

    public void testGetParentTypeId() {
        SimpleNavigationNodeProvider provider = new SimpleNavigationNodeProvider();
        NavigationArgument naviArg = new NavigationArgument(null, new NavigationNodeId("one"));
        TestSecondModuleGroupNodeAssembler naviAssembler = new TestSecondModuleGroupNodeAssembler(){

            public String getParentNodeId() {
                return "application";
            }
        };
        NavigationNodeId parentId = (NavigationNodeId)ReflectionUtils.invokeHidden((Object)provider, (String)"getParentTypeId", (Object[])new Object[]{naviArg, naviAssembler});
        SimpleNavigationNodeProviderTest.assertEquals((String)"one", (String)parentId.getTypeId());
        naviArg = new NavigationArgument();
        parentId = (NavigationNodeId)ReflectionUtils.invokeHidden((Object)provider, (String)"getParentTypeId", (Object[])new Object[]{naviArg, naviAssembler});
        SimpleNavigationNodeProviderTest.assertEquals((String)"application", (String)parentId.getTypeId());
    }

    public void testGetSortedStartupNodeInfos() {
        SimpleNavigationNodeProvider provider = new SimpleNavigationNodeProvider();
        provider.cleanUp();
        List startupNodeInfos = provider.getSortedStartupNodeInfos();
        SimpleNavigationNodeProviderTest.assertNotNull((Object)startupNodeInfos);
        SimpleNavigationNodeProviderTest.assertTrue((boolean)startupNodeInfos.isEmpty());
        TestSecondModuleGroupNodeAssembler naviAssembler = new TestSecondModuleGroupNodeAssembler();
        naviAssembler.setId("ass1");
        naviAssembler.setStartOrder(1);
        provider.registerNavigationAssembler(naviAssembler.getId(), (INavigationAssembler)naviAssembler);
        startupNodeInfos = provider.getSortedStartupNodeInfos();
        SimpleNavigationNodeProviderTest.assertNotNull((Object)startupNodeInfos);
        SimpleNavigationNodeProviderTest.assertTrue((boolean)startupNodeInfos.isEmpty());
        NavigationAssembly2Extension assembly = new NavigationAssembly2Extension();
        naviAssembler.setAssembly((INavigationAssembly2Extension)assembly);
        assembly.setNavigationAssembler(((Object)((Object)naviAssembler)).getClass().getName());
        startupNodeInfos = provider.getSortedStartupNodeInfos();
        SimpleNavigationNodeProviderTest.assertNotNull((Object)startupNodeInfos);
        SimpleNavigationNodeProviderTest.assertEquals((int)1, (int)startupNodeInfos.size());
        StartupNodeInfo startupNodeInfo = (StartupNodeInfo)startupNodeInfos.get(0);
        SimpleNavigationNodeProviderTest.assertEquals((Object)new StartupNodeInfo(StartupNodeInfo.Level.CUSTOM, 1, "ass1"), (Object)startupNodeInfo);
        ModuleNode2Extension moduleExt = new ModuleNode2Extension();
        moduleExt.setNodeId("mod1");
        assembly.setModules(new IModuleNode2Extension[]{moduleExt});
        startupNodeInfos = provider.getSortedStartupNodeInfos();
        SimpleNavigationNodeProviderTest.assertNotNull((Object)startupNodeInfos);
        startupNodeInfo = (StartupNodeInfo)startupNodeInfos.get(0);
        SimpleNavigationNodeProviderTest.assertEquals((Object)new StartupNodeInfo(StartupNodeInfo.Level.MODULE, 1, "mod1"), (Object)startupNodeInfo);
    }

    public void testGetRootNode() {
        MyProvider provider = new MyProvider();
        INavigationNode<?> root = provider.getRootNode((INavigationNode<?>)this.subModule);
        SimpleNavigationNodeProviderTest.assertSame((Object)this.applicationNode, root);
    }

    private static class MyProvider
    extends SimpleNavigationNodeProvider {
        private MyProvider() {
        }

        public INavigationNode<?> findNode(INavigationNode<?> node, NavigationNodeId targetId) {
            return super.findNode(node, targetId);
        }

        protected INavigationNode<?> getRootNode(INavigationNode<?> node) {
            return super.getRootNode(node);
        }
    }
}

