/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.simple.value;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.objecttransaction.AbstractTransactedObject;
import org.eclipse.riena.objecttransaction.IObjectId;
import org.eclipse.riena.objecttransaction.ITransactedObject;
import org.eclipse.riena.objecttransaction.InvalidTransactionFailure;
import org.eclipse.riena.objecttransaction.ObjectTransactionManager;
import org.eclipse.riena.objecttransaction.simple.value.Addresse;
import org.eclipse.riena.objecttransaction.simple.value.GenericOID;
import org.eclipse.riena.objecttransaction.simple.value.Vertrag;

public class Kunde
extends AbstractTransactedObject
implements ITransactedObject {
    private String vorname;
    private String nachname;
    private String kundennr;
    private Addresse addresse;
    private HashSet<Vertrag> vertraege;

    private Kunde() {
        if (!ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            throw new InvalidTransactionFailure("cannot instantiate Kunde with private method if not in clean state");
        }
        ObjectTransactionManager.getInstance().getCurrent().register((ITransactedObject)this);
    }

    public Kunde(String kundennr) {
        super((IObjectId)new GenericOID("kunde", "kundennrpk", kundennr), "1");
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            ObjectTransactionManager.getInstance().getCurrent().register((ITransactedObject)this);
        } else {
            ObjectTransactionManager.getInstance().getCurrent().registerNew((ITransactedObject)this);
        }
        this.setKundennr(kundennr);
        this.vertraege = new HashSet();
    }

    public String getKundennr() {
        return (String)ObjectTransactionManager.getInstance().getCurrent().getReference((ITransactedObject)this, "kundennr", (Object)this.kundennr);
    }

    public void setKundennr(String kundennr) {
        if (((GenericOID)this.getObjectId()).getProperties().get("primkey") != null) {
            throw new UnsupportedOperationException("cannot change kundennr (once it is set)");
        }
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            this.kundennr = kundennr;
        } else {
            ObjectTransactionManager.getInstance().getCurrent().setReference((ITransactedObject)this, "kundennr", (Object)kundennr);
        }
    }

    public String getNachname() {
        return (String)ObjectTransactionManager.getInstance().getCurrent().getReference((ITransactedObject)this, "nachname", (Object)this.nachname);
    }

    public void setNachname(String nachname) {
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            this.nachname = nachname;
        } else {
            ObjectTransactionManager.getInstance().getCurrent().setReference((ITransactedObject)this, "nachname", (Object)nachname);
        }
    }

    public String getVorname() {
        return (String)ObjectTransactionManager.getInstance().getCurrent().getReference((ITransactedObject)this, "vorname", (Object)this.vorname);
    }

    public void setVorname(String vorname) {
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            this.vorname = vorname;
        } else {
            ObjectTransactionManager.getInstance().getCurrent().setReference((ITransactedObject)this, "vorname", (Object)vorname);
        }
    }

    public Addresse getAddresse() {
        return (Addresse)ObjectTransactionManager.getInstance().getCurrent().getReference((ITransactedObject)this, "addresse", (ITransactedObject)this.addresse);
    }

    public void setAddresse(Addresse addresse) {
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            this.addresse = addresse;
        } else {
            ObjectTransactionManager.getInstance().getCurrent().setReference((ITransactedObject)this, "addresse", (ITransactedObject)addresse);
        }
    }

    public void addVertrag(Vertrag vertrag) {
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            this.vertraege.add(vertrag);
        } else {
            ObjectTransactionManager.getInstance().getCurrent().addReference((ITransactedObject)this, "vertrag", (ITransactedObject)vertrag);
        }
    }

    public void removeVertrag(String vertragsNummer) {
        Vertrag tempVertrag = this.getVertrag(vertragsNummer);
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            this.vertraege.remove((Object)this.getVertrag(vertragsNummer));
        } else {
            ObjectTransactionManager.getInstance().getCurrent().removeReference((ITransactedObject)this, "vertrag", (ITransactedObject)tempVertrag);
        }
    }

    public void removeVertrag(Vertrag vertrag) {
        if (ObjectTransactionManager.getInstance().getCurrent().isCleanModus()) {
            this.vertraege.remove((Object)vertrag);
        } else {
            ObjectTransactionManager.getInstance().getCurrent().removeReference((ITransactedObject)this, "vertrag", (ITransactedObject)vertrag);
        }
    }

    public Vertrag getVertrag(String vertragsNummer) {
        Vertrag[] tempVertraege;
        Vertrag[] vertragArray = tempVertraege = this.listVertrag();
        int n = tempVertraege.length;
        int n2 = 0;
        while (n2 < n) {
            Vertrag element = vertragArray[n2];
            if (element.getVertragsNummer().equals(vertragsNummer)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public Vertrag[] listVertrag() {
        Set vertraegeSet = ObjectTransactionManager.getInstance().getCurrent().listReference((ITransactedObject)this, "vertrag", this.vertraege);
        if (vertraegeSet.size() == 0) {
            return new Vertrag[0];
        }
        return vertraegeSet.toArray(new Vertrag[vertraegeSet.size()]);
    }
}

