/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.CompositeRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IMappingCondition;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class DefaultBindingManagerTest
extends TestCase {
    static final String BINDING_PROPERTY = "binding_property";
    private IBindingManager manager;
    private SubModuleController ridgetContainer;
    private Shell shell;
    private DefaultRealm realm;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
        this.manager = new DefaultBindingManager((IBindingPropertyLocator)new BindingPropertyLocator(), (IControlRidgetMapper)new ControlRidgetMapper());
        this.ridgetContainer = new SubModuleController();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.manager = null;
        this.ridgetContainer = null;
        SwtUtilities.dispose((Widget)this.shell);
        this.realm.dispose();
        this.realm = null;
    }

    public void testInjectRidgets() throws Exception {
        ArrayList<Label> uiControls = new ArrayList<Label>(2);
        Label label1 = new Label((Composite)this.shell, 0);
        label1.setData(BINDING_PROPERTY, (Object)"label1");
        uiControls.add(label1);
        Label label2 = new Label((Composite)this.shell, 0);
        label2.setData(BINDING_PROPERTY, (Object)"label2");
        uiControls.add(label2);
        this.manager.injectRidgets((IRidgetContainer)this.ridgetContainer, uiControls);
        DefaultBindingManagerTest.assertNotNull((Object)this.ridgetContainer.getRidget("label1"));
        DefaultBindingManagerTest.assertNull((Object)this.ridgetContainer.getRidget("label1").getUIControl());
        DefaultBindingManagerTest.assertNotNull((Object)this.ridgetContainer.getRidget("label2"));
        DefaultBindingManagerTest.assertNull((Object)this.ridgetContainer.getRidget("label2").getUIControl());
        label1.dispose();
        label2.dispose();
    }

    public void testBind() throws Exception {
        ArrayList<Object> uiControls = new ArrayList<Object>(2);
        Label label1 = new Label((Composite)this.shell, 0);
        label1.setData(BINDING_PROPERTY, (Object)"label1");
        uiControls.add(label1);
        this.manager.injectRidgets((IRidgetContainer)this.ridgetContainer, uiControls);
        this.manager.bind((IRidgetContainer)this.ridgetContainer, uiControls);
        DefaultBindingManagerTest.assertNotNull((Object)this.ridgetContainer.getRidget("label1"));
        DefaultBindingManagerTest.assertSame((Object)label1, (Object)this.ridgetContainer.getRidget("label1").getUIControl());
        ComplexComposite complex = new ComplexComposite((Composite)this.shell, 0);
        complex.setData(BINDING_PROPERTY, "complex1");
        uiControls.add((Object)complex);
        Label label2 = new Label((Composite)complex, 0);
        label2.setData(BINDING_PROPERTY, (Object)"label2");
        this.manager.injectRidgets((IRidgetContainer)this.ridgetContainer, uiControls);
        this.manager.bind((IRidgetContainer)this.ridgetContainer, uiControls);
        IComplexRidget complexRidget = (IComplexRidget)this.ridgetContainer.getRidget("complex1");
        DefaultBindingManagerTest.assertNotNull((Object)complexRidget.getRidget("label2"));
        DefaultBindingManagerTest.assertSame((Object)label2, (Object)complexRidget.getRidget("label2").getUIControl());
        label2.dispose();
        complex.dispose();
        label1.dispose();
    }

    public void testUnbind() throws Exception {
        ArrayList<Label> uiControls = new ArrayList<Label>(2);
        Label label1 = new Label((Composite)this.shell, 0);
        label1.setData(BINDING_PROPERTY, (Object)"label1");
        uiControls.add(label1);
        this.manager.injectRidgets((IRidgetContainer)this.ridgetContainer, uiControls);
        this.manager.bind((IRidgetContainer)this.ridgetContainer, uiControls);
        DefaultBindingManagerTest.assertSame((Object)label1, (Object)this.ridgetContainer.getRidget("label1").getUIControl());
        this.manager.unbind((IRidgetContainer)this.ridgetContainer, uiControls);
        DefaultBindingManagerTest.assertNull((Object)this.ridgetContainer.getRidget("label1").getUIControl());
        label1.dispose();
    }

    public void testCreateRidget() {
        Label label1 = new Label((Composite)this.shell, 0);
        IRidget ridget = (IRidget)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createRidget", (Object[])new Object[]{label1});
        DefaultBindingManagerTest.assertNotNull((Object)ridget);
        DefaultBindingManagerTest.assertTrue((boolean)(ridget instanceof LabelRidget));
        label1.dispose();
    }

    private static final class BindingPropertyLocator
    implements IBindingPropertyLocator {
        private BindingPropertyLocator() {
        }

        public String locateBindingProperty(Object uiControl) {
            Control control = (Control)uiControl;
            return (String)control.getData(DefaultBindingManagerTest.BINDING_PROPERTY);
        }

        public String getComplexBindingId(Object uiControl) {
            return null;
        }
    }

    private class ComplexComposite
    extends Composite
    implements IComplexComponent {
        public ComplexComposite(Composite parent, int style) {
            super(parent, style);
        }

        public List<Object> getUIControls() {
            return SWTBindingPropertyLocator.getControlsWithBindingProperty((Composite)this);
        }
    }

    private static class ControlRidgetMapper
    implements IControlRidgetMapper<Object> {
        private ControlRidgetMapper() {
        }

        public void addMapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz) {
        }

        public void addMapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz, IMappingCondition condition) {
        }

        public Class<? extends IRidget> getRidgetClass(Class<? extends Object> controlClazz) {
            if (controlClazz == ComplexComposite.class) {
                return CompositeRidget.class;
            }
            return LabelRidget.class;
        }

        public Class<? extends IRidget> getRidgetClass(Object control) {
            return this.getRidgetClass(control.getClass());
        }
    }
}

