/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.resource;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IIconManagerExtension;
import org.eclipse.riena.ui.core.resource.IconManager;

public final class IconManagerProvider {
    private static final SingletonProvider<IconManagerProvider> IMP = new SingletonProvider(IconManagerProvider.class);
    private IIconManager iconManager;
    private IIconManager defaultIconManager;

    private IconManagerProvider() {
        this.iconManager = this.defaultIconManager = new IconManager();
    }

    public static IconManagerProvider getInstance() {
        return (IconManagerProvider)IMP.getInstance();
    }

    public IIconManager getIconManager() {
        return this.iconManager;
    }

    public IIconManager getDefaultIconManager() {
        return this.defaultIconManager;
    }

    @InjectExtension
    public void update(IIconManagerExtension[] iconManagerExtensions) {
        if (iconManagerExtensions != null && iconManagerExtensions.length > 0) {
            Arrays.sort(iconManagerExtensions, new IconManagerComparator());
            this.iconManager = iconManagerExtensions[0].createIconManager();
            this.defaultIconManager = iconManagerExtensions.length > 1 ? iconManagerExtensions[iconManagerExtensions.length - 1].createIconManager() : this.iconManager;
        }
    }

    private class IconManagerComparator
    implements Comparator<IIconManagerExtension> {
        private IconManagerComparator() {
        }

        @Override
        public int compare(IIconManagerExtension im1, IIconManagerExtension im2) {
            return Integer.valueOf(im2.getOrder()).compareTo(im1.getOrder());
        }
    }
}

