/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.net.URL;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerProvider;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractLabelRidget
extends AbstractValueRidget
implements ILabelRidget {
    private static final String PROPERTY_TEXT_INTERNAL = "textInternal";
    private static final String EMPTY_STRING = "";
    private String text;
    private String iconID;
    private URL iconLocation;
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;

    @Override
    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    @Override
    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)PROPERTY_TEXT_INTERNAL);
    }

    @Override
    protected void bindUIControl() {
        this.initText();
        this.updateUIText();
        this.updateUIIcon();
    }

    private void initText() {
        Control control;
        if (this.text == null && !this.textAlreadyInitialized && (control = this.getUIControl()) != null && !control.isDisposed()) {
            this.text = this.getUIControlText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    public String getIcon() {
        return this.iconID;
    }

    public URL getIconLocation() {
        return this.iconLocation;
    }

    public String getText() {
        return this.text;
    }

    public final String getTextInternal() {
        return this.getText();
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void setIcon(String icon) {
        this.setIcon(icon, IconSize.NONE);
    }

    public void setIcon(String icon, IconSize size) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIcon = this.iconID;
        IIconManager manager = IconManagerProvider.getInstance().getIconManager();
        this.iconID = manager.getIconID(icon, size);
        if (this.hasChanged(oldIcon, icon) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    public void setIconLocation(URL location) {
        this.useRidgetIcon = true;
        URL oldUrl = this.iconLocation;
        this.iconLocation = location;
        if (this.hasChanged(oldUrl, location)) {
            this.updateUIIcon();
        }
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.updateUIText();
        this.firePropertyChange(PROPERTY_TEXT_INTERNAL, oldValue, this.text);
        this.firePropertyChange("text", oldValue, this.text);
    }

    public final void setTextInternal(String text) {
        this.setText(text);
    }

    protected abstract String getUIControlText();

    private void updateUIText() {
        if (this.getUIControl() != null) {
            this.setUIControlText(this.text);
        }
    }

    protected abstract void setUIControlText(String var1);

    private void updateUIIcon() {
        if (this.getUIControl() != null) {
            Image image = null;
            if (this.getIcon() != null) {
                image = this.getManagedImage(this.getIcon());
            } else if (this.iconLocation != null) {
                String key = this.iconLocation.toExternalForm();
                image = this.getManagedImage(key);
            }
            if (image != null || this.useRidgetIcon) {
                this.setUIControlImage(image);
            }
        }
    }

    protected abstract void setUIControlImage(Image var1);

    private boolean hasChanged(URL oldValue, URL newValue) {
        String str2;
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        String str1 = oldValue.toExternalForm();
        return !str1.equals(str2 = newValue.toExternalForm());
    }
}

