/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.util.List;
import org.eclipse.riena.internal.ui.ridgets.swt.ContextMenuDelegate;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.IMenuItemRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.FocusManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractSWTRidget
extends AbstractSWTWidgetRidget {
    private static final String IS_SUB_MODULE_VIEW_COMPOSITE = "isSubModuleViewComposite";
    private final FocusManager focusManager = new FocusManager(this);
    private boolean focusable = true;
    private final ContextMenuDelegate contextMenuDelegate = new ContextMenuDelegate();

    public FocusManager getFocusManager() {
        return this.focusManager;
    }

    public Control getUIControl() {
        return (Control)super.getUIControl();
    }

    @Override
    public final void requestFocus() {
        if (this.isFocusable() && this.getUIControl() != null) {
            Control control = this.getUIControl();
            this.setRetryRequestFocus(!control.setFocus());
        }
    }

    @Override
    public boolean hasFocus() {
        Control control = this.getUIControl();
        if (!SwtUtilities.isDisposed((Widget)control)) {
            return control.isFocusControl();
        }
        return false;
    }

    @Override
    public final boolean isFocusable() {
        return this.focusable;
    }

    @Override
    public final void setFocusable(boolean focusable) {
        if (this.focusable != focusable) {
            this.focusable = focusable;
        }
    }

    public boolean isVisible() {
        if (!this.getMarkersOfType(HiddenMarker.class).isEmpty()) {
            return false;
        }
        if (!SwtUtilities.isDisposed((Widget)this.getUIControl())) {
            if (this.isChildOfSubModuleView(this.getUIControl())) {
                return this.isControlVisible(this.getUIControl());
            }
            return this.getUIControl().isVisible();
        }
        return this.savedVisibleState;
    }

    private boolean isSubModuleViewComposite(Control uiControl) {
        if (!(uiControl instanceof Composite)) {
            return false;
        }
        return uiControl.getData(IS_SUB_MODULE_VIEW_COMPOSITE) instanceof Boolean && (Boolean)uiControl.getData(IS_SUB_MODULE_VIEW_COMPOSITE) != false;
    }

    private boolean isChildOfSubModuleView(Control uiControl) {
        if (uiControl.getVisible()) {
            Composite parent = uiControl.getParent();
            if (parent == null) {
                return false;
            }
            if (this.isSubModuleViewComposite((Control)parent)) {
                return true;
            }
            return this.isChildOfSubModuleView((Control)parent);
        }
        return false;
    }

    private boolean isControlVisible(Control uiControl) {
        if (uiControl.getVisible()) {
            Composite parent = uiControl.getParent();
            if (parent == null) {
                return true;
            }
            if (this.isSubModuleViewComposite((Control)parent)) {
                return true;
            }
            return this.isControlVisible((Control)parent);
        }
        return false;
    }

    @Override
    protected void unbindUIControl() {
        this.savedVisibleState = this.isVisible();
    }

    @Override
    protected final void installListeners() {
        super.installListeners();
        Control control = this.getUIControl();
        if (!SwtUtilities.isDisposed((Widget)control)) {
            this.focusManager.addListeners(control);
        }
    }

    @Override
    protected final void uninstallListeners() {
        Control control = this.getUIControl();
        if (!SwtUtilities.isDisposed((Widget)control)) {
            this.focusManager.removeListeners(control);
        }
        super.uninstallListeners();
    }

    @Override
    protected final void updateEnabled() {
        if (!SwtUtilities.isDisposed((Widget)this.getUIControl())) {
            this.getUIControl().setEnabled(this.isEnabled());
        }
    }

    @Override
    protected final void updateToolTip() {
        if (!SwtUtilities.isDisposed((Widget)this.getUIControl())) {
            this.getUIControl().setToolTipText(this.getToolTipText());
        }
    }

    @Override
    public final void setUIControl(Object uiControl) {
        super.setUIControl(uiControl);
        this.updateContextMenu();
    }

    private void updateContextMenu() {
        if (SwtUtilities.isDisposed((Widget)this.getUIControl())) {
            return;
        }
        List<IMenuItemRidget> menuItems = this.contextMenuDelegate.getMenuItems();
        if (menuItems != null && !menuItems.isEmpty()) {
            Menu menu = this.getUIControl().getMenu();
            if (menu != null) {
                this.getUIControl().setMenu(null);
                menu.dispose();
            }
            menu = UIControlsFactory.createMenu((Control)this.getUIControl());
            this.getUIControl().setMenu(menu);
            for (IMenuItemRidget item : menuItems) {
                MenuItem uiItem = UIControlsFactory.createMenuItem((Menu)menu, (String)item.getText(), (String)item.getText());
                item.setUIControl((Object)uiItem);
            }
        }
    }

    public IMenuItemRidget addMenuItem(String itemText) {
        return this.addMenuItem(itemText, null);
    }

    public IMenuItemRidget addMenuItem(String itemText, String iconName) {
        IMenuItemRidget item = this.contextMenuDelegate.addMenuItem(itemText, iconName);
        this.updateContextMenu();
        return item;
    }

    public void removeMenuItem(String menuItemText) {
        this.contextMenuDelegate.removeMenuItem(menuItemText);
        this.updateContextMenu();
    }

    public void removeMenuItem(IMenuItemRidget menuItemRidget) {
        this.contextMenuDelegate.removeMenuItem(menuItemRidget);
        this.updateContextMenu();
    }

    public IMenuItemRidget getMenuItem(int index) {
        return this.contextMenuDelegate.getMenuItem(index);
    }

    public int getMenuItemCount() {
        return this.contextMenuDelegate.getMenuItemCount();
    }
}

