/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.facades;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.facades.WorkbenchFacade;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.services.ISourceProviderService;

public class WorkbenchFacadeImpl
extends WorkbenchFacade {
    private static final Logger LOGGER = Log4r.getLogger(WorkbenchFacadeImpl.class);

    public void showView(IWorkbenchPage page, IViewReference viewRef) {
        ((WorkbenchPage)page).getActivePerspective().bringToTop(viewRef);
    }

    public Shell getActiveShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public boolean closeWorkbench() {
        return PlatformUI.getWorkbench().close();
    }

    public Shell getActiveWindowShell() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public Display getWorkbenchDisplay() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getDisplay() != null) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return null;
    }

    private ISourceProviderService getSourceProviderService() {
        return (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
    }

    public ISourceProvider[] getSourceProviders() {
        try {
            ISourceProviderService sourceProviderService = this.getSourceProviderService();
            if (sourceProviderService == null) {
                return new ISourceProvider[0];
            }
            return sourceProviderService.getSourceProviders();
        }
        catch (IllegalStateException ex) {
            LOGGER.log(1, "No service for ISourceProviderService!", (Throwable)ex);
            return new ISourceProvider[0];
        }
    }
}

