/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.dtd.internal.DtdParserImpl;
import org.eclipse.sapphire.modeling.xml.schema.UrlResolver;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DtdParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XmlDocumentSchema parse(URL url) {
        XmlDocumentSchema xmlDocumentSchema;
        InputStream in = null;
        try {
            in = url.openStream();
            xmlDocumentSchema = DtdParser.parse(MiscUtil.readTextContent((InputStream)in));
            if (in == null) return xmlDocumentSchema;
        }
        catch (Exception e) {
            try {
                String message = NLS.bind((String)Resources.parseFailed, (Object[])new Object[]{url});
                throw new RuntimeException(message, e);
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            in.close();
            return xmlDocumentSchema;
        }
        catch (IOException iOException) {}
        return xmlDocumentSchema;
    }

    public static XmlDocumentSchema parse(String dtd) {
        try {
            String content = dtd;
            DtdParserImpl parser = new DtdParserImpl(new StringReader(content));
            parser.Start();
            if (!parser.entities.isEmpty()) {
                String substitutedContent = DtdParser.substituteEntity(content, parser.entities);
                while (!content.equals(substitutedContent)) {
                    content = substitutedContent;
                    substitutedContent = DtdParser.substituteEntity(content, parser.entities);
                }
                parser = new DtdParserImpl(new StringReader(content));
                parser.Start();
            }
            return parser.schema.create();
        }
        catch (Exception e) {
            String message = NLS.bind((String)Resources.parseFailed, (Object[])new Object[]{"##string##"});
            throw new RuntimeException(message, e);
        }
    }

    private static String substituteEntity(String content, Map<String, String> entities) {
        for (Map.Entry<String, String> entity : entities.entrySet()) {
            content = content.replace("%" + entity.getKey() + ";", entity.getValue());
        }
        return content;
    }

    @Deprecated
    public static XmlDocumentSchema parseFromUrl(String referer, String url) {
        URL dtdLocationUrl;
        try {
            dtdLocationUrl = new URL(UrlResolver.resolve(referer, url));
        }
        catch (MalformedURLException e) {
            String message = NLS.bind((String)Resources.parseFailed, (Object[])new Object[]{url});
            throw new RuntimeException(message, e);
        }
        return DtdParser.parse(dtdLocationUrl);
    }

    @Deprecated
    public static XmlDocumentSchema parseFromString(String dtd) {
        return DtdParser.parse(dtd);
    }

    private static final class Resources
    extends NLS {
        public static String parseFailed;

        static {
            Resources.initializeMessages((String)DtdParser.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

