/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionCompatibilityTarget;
import org.eclipse.sapphire.VersionCompatibilityTargetService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class DeclarativeVersionCompatibilityTargetService
extends VersionCompatibilityTargetService {
    private FunctionResult versionFunctionResult;
    private FunctionResult versionedFunctionResult;

    protected void initContextVersionService() {
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        VersionCompatibilityTarget versionCompatibilityTargetAnnotation = property != null ? property.getAnnotation(VersionCompatibilityTarget.class) : element.type().getAnnotation(VersionCompatibilityTarget.class);
        Function versionFunction = null;
        try {
            versionFunction = ExpressionLanguageParser.parse(versionCompatibilityTargetAnnotation.version());
        }
        catch (Exception e) {
            LoggingService.log(e);
        }
        if (versionFunction == null) {
            versionFunction = Literal.NULL;
            this.versionedFunctionResult = versionFunction.evaluate(new FunctionContext());
        } else {
            versionFunction = FailSafeFunction.create(versionFunction, Literal.create(Version.class), null);
            this.versionFunctionResult = versionFunction.evaluate(new ModelElementFunctionContext(element));
            this.versionFunctionResult.attach(new Listener(){

                public void handle(Event event) {
                    DeclarativeVersionCompatibilityTargetService.this.refresh();
                }
            });
        }
        Function versionedFunction = null;
        try {
            versionedFunction = ExpressionLanguageParser.parse(versionCompatibilityTargetAnnotation.versioned());
        }
        catch (Exception e) {
            LoggingService.log(e);
        }
        if (versionedFunction == null) {
            versionedFunction = Literal.NULL;
            this.versionedFunctionResult = versionedFunction.evaluate(new FunctionContext());
        } else {
            versionedFunction = FailSafeFunction.create(versionedFunction, Literal.create(String.class), null);
            this.versionedFunctionResult = versionedFunction.evaluate(new ModelElementFunctionContext(element));
            this.versionedFunctionResult.attach(new Listener(){

                public void handle(Event event) {
                    DeclarativeVersionCompatibilityTargetService.this.refresh();
                }
            });
        }
    }

    protected VersionCompatibilityTargetService.Data compute() {
        return new VersionCompatibilityTargetService.Data((Version)this.versionFunctionResult.value(), (String)this.versionedFunctionResult.value());
    }

    public void dispose() {
        super.dispose();
        if (this.versionFunctionResult != null) {
            try {
                this.versionFunctionResult.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
        if (this.versionFunctionResult != null) {
            try {
                this.versionFunctionResult.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ModelProperty property = context.find(ModelProperty.class);
            if (property != null) {
                return property.hasAnnotation(VersionCompatibilityTarget.class);
            }
            IModelElement element = context.find(IModelElement.class);
            return element != null && element.type().hasAnnotation(VersionCompatibilityTarget.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new DeclarativeVersionCompatibilityTargetService();
        }
    }
}

