/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.ValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transient<T>
extends ModelParticle {
    private final TransientProperty property;
    private final T content;
    private Boolean enablement;
    private Status validation;

    public Transient(IModelElement parent, TransientProperty property, T content) {
        super(parent, parent.resource());
        this.property = property;
        this.content = content;
        this.validation = null;
    }

    public void init() {
        this.initEnablement();
        this.initValidation();
    }

    private void initEnablement() {
        if (this.enablement == null) {
            boolean enablement = true;
            for (EnablementService service : this.parent().services(this.property, EnablementService.class)) {
                boolean bl = enablement = enablement && service.enablement();
                if (!enablement) break;
            }
            this.enablement = enablement;
        }
    }

    private void initValidation() {
        if (this.validation == null) {
            Status.CompositeStatusFactory factory = Status.factoryForComposite();
            for (ValidationService svc : this.parent().services(this.property, ValidationService.class)) {
                try {
                    factory.merge(svc.validate());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            this.validation = factory.create();
        }
    }

    @Override
    public IModelElement parent() {
        return (IModelElement)super.parent();
    }

    public TransientProperty property() {
        return this.property;
    }

    public T content() {
        return this.content;
    }

    public boolean enabled() {
        this.initEnablement();
        return this.enablement;
    }

    @Override
    public Status validation() {
        this.initValidation();
        return this.validation;
    }

    public boolean equals(Object val) {
        if (this == val) {
            return true;
        }
        if (val == null) {
            return false;
        }
        this.init();
        Transient value = (Transient)val;
        return this.parent() == value.parent() && this.property == value.property && MiscUtil.equal(this.content, value.content) && MiscUtil.equal(this.enablement, value.enablement) && MiscUtil.equal(this.validation, value.validation);
    }

    public int hashCode() {
        int hashCode = this.parent().hashCode();
        hashCode ^= this.property.hashCode();
        return hashCode ^= this.content == null ? 1 : this.content.hashCode();
    }

    public String toString() {
        return this.content == null ? "<null>" : this.content.toString();
    }
}

