/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.util.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileExtensionsServiceData {
    private final List<String> extensions;

    public FileExtensionsServiceData(Collection<String> extensions) {
        ArrayList<String> clean = new ArrayList<String>();
        for (String extension : extensions) {
            if (extension == null || (extension = extension.trim()).length() <= 0) continue;
            clean.add(extension);
        }
        this.extensions = Collections.unmodifiableList(clean);
    }

    public FileExtensionsServiceData(String ... extensions) {
        this(MiscUtil.list(extensions));
    }

    public List<String> extensions() {
        return this.extensions;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileExtensionsServiceData) {
            FileExtensionsServiceData data = (FileExtensionsServiceData)obj;
            return this.extensions.equals(data.extensions);
        }
        return false;
    }

    public int hashCode() {
        return this.extensions.hashCode();
    }
}

