/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.services.DataService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceFactoryProxy;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContext {
    public static final String ID_ELEMENT_INSTANCE = "Sapphire.Element.Instance";
    public static final String ID_ELEMENT_METAMODEL = "Sapphire.Element.MetaModel";
    public static final String ID_PROPERTY_INSTANCE = "Sapphire.Property.Instance";
    public static final String ID_PROPERTY_METAMODEL = "Sapphire.Property.MetaModel";
    private final String type;
    private final ServiceContext parent;
    private final List<Service> services = new ArrayList<Service>();
    private final Set<Class<?>> initializingServiceTypes = new HashSet();
    private final Set<Class<?>> initializedServiceTypes = new HashSet();
    private final Set<String> exhaustedServiceFactories = new HashSet<String>();
    private ListenerContext coordinatingListenerContext;
    private boolean disposed = false;

    public ServiceContext(String type, ServiceContext parent) {
        this.type = type;
        this.parent = parent;
    }

    public final String type() {
        return this.type;
    }

    public final ServiceContext parent() {
        return this.parent;
    }

    public <T> T find(Class<T> type) {
        return null;
    }

    public final <S extends Service> S service(Class<S> serviceType) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    public final synchronized <S extends Service> List<S> services(Class<S> serviceType) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        if (!this.initializedServiceTypes.contains(serviceType)) {
            if (this.initializingServiceTypes.contains(serviceType)) {
                throw new IllegalStateException();
            }
            this.initializingServiceTypes.add(serviceType);
            Class<S> serviceTypeSuperClass = serviceType.getSuperclass();
            if (serviceTypeSuperClass == Service.class || serviceTypeSuperClass == DataService.class) {
                Service service;
                String id;
                HashMap<String, ServiceFactoryProxy> applicable = new HashMap<String, ServiceFactoryProxy>();
                for (ServiceFactoryProxy serviceFactoryProxy : SapphireModelingExtensionSystem.getServiceFactories()) {
                    if (!serviceFactoryProxy.applicable(this, serviceType)) continue;
                    applicable.put(serviceFactoryProxy.id(), serviceFactoryProxy);
                }
                for (ServiceFactoryProxy serviceFactoryProxy : new ArrayList(applicable.values())) {
                    for (String overriddenServiceId : serviceFactoryProxy.overrides()) {
                        applicable.remove(overriddenServiceId);
                    }
                }
                for (ServiceFactoryProxy serviceFactoryProxy : this.local()) {
                    id = serviceFactoryProxy.id();
                    if (this.exhaustedServiceFactories.contains(id) || !serviceFactoryProxy.applicable(this, serviceType)) continue;
                    this.exhaustedServiceFactories.add(id);
                    service = null;
                    try {
                        service = serviceFactoryProxy.create(this, serviceType);
                        service.init(this, serviceFactoryProxy.parameters());
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                    if (service == null) continue;
                    if (this.coordinatingListenerContext != null) {
                        service.coordinate(this.coordinatingListenerContext);
                    }
                    for (String overriddenServiceId : serviceFactoryProxy.overrides()) {
                        applicable.remove(overriddenServiceId);
                    }
                    this.services.add(service);
                }
                for (ServiceFactoryProxy serviceFactoryProxy : applicable.values()) {
                    id = serviceFactoryProxy.id();
                    if (this.exhaustedServiceFactories.contains(id)) continue;
                    this.exhaustedServiceFactories.add(id);
                    service = null;
                    try {
                        service = serviceFactoryProxy.create(this, serviceType);
                        service.init(this, serviceFactoryProxy.parameters());
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                    if (service == null) continue;
                    if (this.coordinatingListenerContext != null) {
                        service.coordinate(this.coordinatingListenerContext);
                    }
                    this.services.add(service);
                }
            } else {
                this.services(serviceTypeSuperClass);
            }
            this.initializingServiceTypes.remove(serviceType);
            this.initializedServiceTypes.add(serviceType);
        }
        ListFactory<Service> matchedServicesListFactory = ListFactory.start();
        for (Service service : this.services) {
            if (!serviceType.isInstance(service)) continue;
            matchedServicesListFactory.add((Service)serviceType.cast(service));
        }
        int i = 0;
        int n = matchedServicesListFactory.size();
        while (i < n) {
            ((Service)matchedServicesListFactory.get(i)).initIfNecessary();
            ++i;
        }
        if (this.parent != null && matchedServicesListFactory.size() == 0) {
            matchedServicesListFactory.add((Collection<Service>)this.parent.services(serviceType));
        }
        return matchedServicesListFactory.result();
    }

    public final void coordinate(ListenerContext context) {
        this.coordinatingListenerContext = context;
    }

    protected List<ServiceFactoryProxy> local() {
        return Collections.emptyList();
    }

    public final void dispose() {
        this.disposed = true;
        for (Service service : this.services) {
            try {
                service.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
        this.services.clear();
    }
}

