/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.Serializable;

public class CompositeObject
implements Comparable<CompositeObject>,
Serializable {
    private static final long serialVersionUID = 0L;
    private Object[] m_value;

    public CompositeObject(Object ... a) {
        this.m_value = a;
    }

    public int hashCode() {
        long h = 0L;
        Object[] objectArray = this.m_value;
        int n = this.m_value.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            if (v != null) {
                h ^= (long)v.hashCode();
            }
            ++n2;
        }
        return (int)h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositeObject)) {
            return false;
        }
        return this.compareTo((CompositeObject)o) == 0;
    }

    public int getComponentCount() {
        return this.m_value.length;
    }

    public Object getComponent(int index) {
        return this.m_value[index];
    }

    public Object[] getComponents() {
        return this.m_value;
    }

    @Override
    public int compareTo(CompositeObject o) {
        Object[] me = this.m_value;
        Object[] other = o.m_value;
        int i = 0;
        while (i < me.length && i < other.length) {
            int c = this.compareImpl(me[i], other[i]);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        if (me.length < other.length) {
            return -1;
        }
        if (me.length > other.length) {
            return 1;
        }
        return 0;
    }

    private int compareImpl(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        return a.toString().compareTo(b.toString());
    }

    public String toString() {
        String s = "[";
        int i = 0;
        while (i < this.m_value.length) {
            s = String.valueOf(s) + String.valueOf(this.m_value[i]);
            if (i + 1 < this.m_value.length) {
                s = String.valueOf(s) + ",";
            }
            ++i;
        }
        s = String.valueOf(s) + "]";
        return s;
    }
}

