/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.eclipse.scout.commons.StreamDumper;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class IOUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(IOUtility.class);

    private IOUtility() {
    }

    public static byte[] getContent(InputStream stream) throws ProcessingException {
        return IOUtility.getContent(stream, true);
    }

    public static byte[] getContent(InputStream stream, boolean autoClose) throws ProcessingException {
        BufferedInputStream in = null;
        try {
            byte[] data;
            int len;
            in = new BufferedInputStream(stream);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] b = new byte[10240];
            while ((len = in.read(b)) > 0) {
                buffer.write(b, 0, len);
            }
            buffer.close();
            byte[] byArray = data = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new ProcessingException("input: " + stream, e);
        }
        finally {
            try {
                if (autoClose && in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new ProcessingException("input: " + stream, e);
            }
        }
    }

    public static byte[] getContent(String filename) throws ProcessingException {
        try {
            return IOUtility.getContent(new FileInputStream(IOUtility.toFile(filename)), true);
        }
        catch (FileNotFoundException e) {
            throw new ProcessingException("filename: " + filename, e);
        }
    }

    public static String getContentInEncoding(String filepath, String encoding) throws ProcessingException {
        try {
            FileInputStream in = null;
            String content = null;
            try {
                in = new FileInputStream(filepath);
                content = StringUtility.hasText(encoding) ? IOUtility.getContent(new InputStreamReader((InputStream)in, encoding)) : IOUtility.getContent(new InputStreamReader(in));
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return content;
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    public static void writeContent(OutputStream stream, byte[] data) throws ProcessingException {
        IOUtility.writeContent(stream, data, true);
    }

    public static void writeContent(OutputStream stream, byte[] data, boolean autoClose) throws ProcessingException {
        BufferedOutputStream out = null;
        try {
            try {
                out = new BufferedOutputStream(stream);
                out.write(data);
            }
            catch (IOException e) {
                throw new ProcessingException("output: " + stream, e);
            }
        }
        finally {
            try {
                if (autoClose && out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new ProcessingException("output: " + stream, e);
            }
        }
    }

    public static void writeContent(String filename, Object o) throws ProcessingException {
        File f = IOUtility.toFile(filename);
        try {
            if (o instanceof byte[]) {
                IOUtility.writeContent(new FileOutputStream(f), (byte[])o);
            } else if (o instanceof char[]) {
                IOUtility.writeContent(new FileWriter(f), new String((char[])o));
            } else if (o != null) {
                IOUtility.writeContent(new FileWriter(f), o.toString());
            }
        }
        catch (FileNotFoundException n) {
            throw new ProcessingException("filename: " + filename, n);
        }
        catch (IOException e) {
            throw new ProcessingException("filename: " + filename, e);
        }
    }

    public static void writeContent(Writer stream, String text) throws ProcessingException {
        IOUtility.writeContent(stream, text, true);
    }

    public static void writeContent(Writer stream, String text, boolean autoClose) throws ProcessingException {
        try {
            try {
                stream.write(text);
            }
            catch (IOException e) {
                throw new ProcessingException("output: " + stream, e);
            }
        }
        finally {
            try {
                if (autoClose && stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new ProcessingException("output: " + stream, e);
            }
        }
    }

    public static String getContent(Reader stream) throws ProcessingException {
        return IOUtility.getContent(stream, true);
    }

    public static String getContent(Reader stream, boolean autoClose) throws ProcessingException {
        BufferedReader in = null;
        try {
            int len;
            in = new BufferedReader(stream);
            StringWriter buffer = new StringWriter();
            char[] b = new char[10240];
            while ((len = in.read(b)) > 0) {
                buffer.write(b, 0, len);
            }
            buffer.close();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            throw new ProcessingException("input: " + stream, e);
        }
        finally {
            try {
                if (autoClose && in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new ProcessingException("input: " + stream, e);
            }
        }
    }

    public static File[] listFilesInSubtree(File dir, FileFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        IOUtility.listFilesRec(dir, filter, list);
        return list.toArray(new File[list.size()]);
    }

    private static void listFilesRec(File dir, FileFilter filter, ArrayList<File> intoList) {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            File[] a = dir.listFiles(filter);
            int i = 0;
            while (a != null && i < a.length) {
                if (a[i].isDirectory()) {
                    IOUtility.listFilesRec(a[i], filter, intoList);
                } else {
                    intoList.add(a[i]);
                }
                ++i;
            }
        }
    }

    public static File createTempDirectory(String dirSuffix) throws ProcessingException {
        try {
            if (dirSuffix != null) {
                dirSuffix = dirSuffix.replaceAll("[:*?\\\"<>|]*", "");
            }
            File tmp = File.createTempFile("dir", dirSuffix);
            tmp.delete();
            tmp.mkdirs();
            tmp.deleteOnExit();
            return tmp;
        }
        catch (IOException e) {
            throw new ProcessingException("dir: " + dirSuffix, e);
        }
    }

    public static File createTempFile(String fileName, byte[] content) throws ProcessingException {
        try {
            File f;
            File f2;
            if (fileName != null) {
                fileName = fileName.replaceAll("[\\\\/:*?\\\"<>|]*", "");
            }
            if (fileName == null || fileName.length() == 0) {
                fileName = IOUtility.getTempFileName("tmp");
            }
            if ((f2 = new File((f = File.createTempFile("tmp", ".tmp")).getParentFile(), new File(fileName).getName())).exists() && !f2.delete()) {
                throw new IOException("File " + f2 + " exists and cannot be deleted");
            }
            boolean ok = f.renameTo(f2);
            if (!ok) {
                throw new IOException("failed renaming " + f + " to " + f2);
            }
            f2.deleteOnExit();
            if (content != null) {
                IOUtility.writeContent(new FileOutputStream(f2), content);
            } else {
                f2.createNewFile();
            }
            return f2;
        }
        catch (IOException e) {
            throw new ProcessingException("filename: " + fileName, e);
        }
    }

    public static File createTempFile(String prefix, String suffix, byte[] content) throws ProcessingException {
        File f = null;
        try {
            f = File.createTempFile(prefix, suffix);
            f.deleteOnExit();
            if (content != null) {
                IOUtility.writeContent(new FileOutputStream(f), content);
            }
            return f;
        }
        catch (IOException e) {
            throw new ProcessingException("filename: " + f, e);
        }
    }

    public static boolean deleteDirectory(File dir) {
        if (dir != null && dir.exists()) {
            File[] a = dir.listFiles();
            int i = 0;
            while (a != null && i < a.length) {
                if (a[i].isDirectory()) {
                    IOUtility.deleteDirectory(a[i]);
                } else {
                    a[i].delete();
                }
                ++i;
            }
            return dir.delete();
        }
        return true;
    }

    public static boolean deleteDirectory(String dir) {
        File f = IOUtility.toFile(dir);
        if (f.exists()) {
            return IOUtility.deleteDirectory(f);
        }
        return false;
    }

    public static boolean createDirectory(String dir) {
        if (dir != null) {
            dir = dir.replaceAll("[*?\\\"<>|]*", "");
            File f = IOUtility.toFile(dir);
            return f.mkdirs();
        }
        return false;
    }

    public static boolean deleteFile(String filePath) {
        File f;
        if (filePath != null && (f = IOUtility.toFile(filePath)).exists()) {
            return f.delete();
        }
        return false;
    }

    public static String exec(String cmd, String[] envp, File dir) throws ProcessingException {
        StringWriter sw = new StringWriter();
        try {
            Process p = Runtime.getRuntime().exec(cmd, envp, dir);
            new StreamDumper(p.getInputStream(), sw).start();
            new StreamDumper(p.getErrorStream(), sw).start();
            int code = -1;
            try {
                code = p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (code != 0) {
                throw new IOException("returncode is " + code);
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw new ProcessingException("cmd: " + cmd, e);
        }
    }

    public static long getFileSize(String filepath) {
        if (filepath == null) {
            return 0L;
        }
        File f = IOUtility.toFile(filepath);
        return IOUtility.getFileSize(f);
    }

    public static long getFileSize(File filepath) {
        if (filepath == null) {
            return 0L;
        }
        if (filepath.exists()) {
            return filepath.length();
        }
        return 0L;
    }

    public static long getFileLastModified(String filepath) {
        if (filepath == null) {
            return 0L;
        }
        File f = IOUtility.toFile(filepath);
        if (f.exists()) {
            return f.lastModified();
        }
        return 0L;
    }

    public static String getFileName(String filepath) {
        if (filepath == null) {
            return null;
        }
        File f = IOUtility.toFile(filepath);
        return f.getName();
    }

    public static File toFile(String s) {
        if (s == null) {
            return null;
        }
        return new File(s.replace('\\', File.separatorChar).replace('/', File.separatorChar));
    }

    public static String getFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int i = filename.lastIndexOf(".");
        if (i < 0) {
            return null;
        }
        return filename.substring(i + 1);
    }

    public static String getFilePath(String filepath) {
        if (filepath == null) {
            return null;
        }
        File f = IOUtility.toFile(filepath);
        return f.getParent();
    }

    public static boolean fileExists(String s) {
        if (s != null) {
            File f = IOUtility.toFile(s);
            return f.exists();
        }
        return false;
    }

    public static String getTempFileName(String fileExtension) throws ProcessingException {
        try {
            File f = File.createTempFile("tmp", fileExtension);
            f.delete();
            return f.getAbsolutePath();
        }
        catch (IOException e) {
            throw new ProcessingException("extension: " + fileExtension, e);
        }
    }

    public static String urlEncode(String o) throws ProcessingException {
        String s = o == null ? "" : o.toString().trim();
        if (s.length() == 0) {
            s = " ";
        }
        try {
            s = URLEncoder.encode(s, "UTF-8");
            s = StringUtility.replace(s, "+", "%20");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }

    public static String urlDecode(String o) throws ProcessingException {
        String s = o == null ? "" : o.toString().trim();
        try {
            s = URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return s;
    }

    public static URL urlTextToUrl(String urlText) {
        String text = urlText;
        URL url = null;
        if (text != null && text.length() > 0) {
            try {
                url = new URL(text);
            }
            catch (Exception e) {
                text = text.contains("@") ? "mailto:" + text : "http://" + text;
                try {
                    url = new URL(text);
                }
                catch (Exception e1) {
                    LOG.debug("Could not create url from : " + text + ":" + e1);
                }
            }
        }
        return url;
    }
}

