/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.nls;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class NlsUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(NlsUtility.class);
    private static final int MOD_EXPECTED = 9;
    private static final int MOD_MASK = 25;
    private static Pattern messageArgumentPattern = Pattern.compile("\\{([0-9]+)\\}");

    private NlsUtility() {
    }

    public static void dynamicBindFields(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        boolean isAccessible = (clazz.getModifiers() & 1) != 0;
        Field[] fieldArray2 = fieldArray;
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if ((field.getModifiers() & 0x19) == 9) {
                try {
                    if (!isAccessible) {
                        NlsUtility.makeAccessible(field);
                    }
                    field.set(null, field.getName());
                }
                catch (Exception e) {
                    LOG.warn(null, e);
                }
            }
            ++n2;
        }
    }

    static void makeAccessible(final Field field) {
        if (System.getSecurityManager() == null) {
            field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
        }
    }

    public static String bindText(String text, String ... messageArguments) {
        if (text != null) {
            if (messageArguments != null && messageArguments.length > 0) {
                Matcher m = messageArgumentPattern.matcher(text);
                StringBuilder b = new StringBuilder();
                int start = 0;
                while (m.find(start)) {
                    b.append(text.substring(start, m.start()));
                    int index = Integer.parseInt(m.group(1));
                    if (index < messageArguments.length) {
                        if (messageArguments[index] != null) {
                            b.append(messageArguments[index]);
                        }
                    } else {
                        b.append("{" + index + "}");
                    }
                    start = m.end();
                }
                b.append(text.substring(start));
                return b.toString();
            }
            return text;
        }
        return text;
    }

    public static Locale parseLocale(String pattern) {
        if (pattern == null) {
            return LocaleThreadLocal.get();
        }
        String[] a = pattern.split("_");
        switch (a.length) {
            case 1: {
                return new Locale(a[0]);
            }
            case 2: {
                return new Locale(a[0], a[1]);
            }
            case 3: {
                return new Locale(a[0], a[1], a[2]);
            }
        }
        return LocaleThreadLocal.get();
    }

    public static Locale getDefaultLocale() {
        Locale locale = LocaleThreadLocal.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

