/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.osgi.framework.Bundle;

public class BundleListClassLoader
extends ClassLoader {
    private static final HashMap<String, Class> PRIMITIVE_TYPES = new HashMap(8, 1.0f);
    private final Bundle[] m_bundles;
    private final Bundle[] m_bundlesSortedByBundleSymbolicNameLenght;
    private final Map<String, Class<?>> m_classCache;

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("Z", Boolean.TYPE);
        PRIMITIVE_TYPES.put("B", Byte.TYPE);
        PRIMITIVE_TYPES.put("C", Character.TYPE);
        PRIMITIVE_TYPES.put("S", Short.TYPE);
        PRIMITIVE_TYPES.put("I", Integer.TYPE);
        PRIMITIVE_TYPES.put("J", Long.TYPE);
        PRIMITIVE_TYPES.put("F", Float.TYPE);
        PRIMITIVE_TYPES.put("D", Double.TYPE);
        PRIMITIVE_TYPES.put("V", Void.TYPE);
    }

    public BundleListClassLoader(Bundle ... bundles) {
        if (bundles == null || bundles.length == 0) {
            throw new IllegalArgumentException("bundle list must not be null or empty");
        }
        this.m_bundles = BundleInspector.filterPluginBundles(bundles);
        if (this.m_bundles.length == 0) {
            throw new IllegalArgumentException("filtered bundle list must not be empty. [bundles=" + Arrays.toString(bundles) + "]");
        }
        this.m_bundlesSortedByBundleSymbolicNameLenght = new Bundle[this.m_bundles.length];
        System.arraycopy(this.m_bundles, 0, this.m_bundlesSortedByBundleSymbolicNameLenght, 0, this.m_bundles.length);
        Arrays.sort(this.m_bundlesSortedByBundleSymbolicNameLenght, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle b1, Bundle b2) {
                if (b1 == null && b2 == null) {
                    return 0;
                }
                if (b1 == null) {
                    return -1;
                }
                if (b2 == null) {
                    return 1;
                }
                return StringUtility.length(b2.getSymbolicName()) - StringUtility.length(b1.getSymbolicName());
            }
        });
        this.m_classCache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> putInCache(String name, Class<?> c) {
        if (c != null) {
            Map<String, Class<?>> map = this.m_classCache;
            synchronized (map) {
                this.m_classCache.put(name, c);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(String className) {
        Map<String, Class<?>> map = this.m_classCache;
        synchronized (map) {
            this.m_classCache.put(className, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        Map<String, Class<?>> map = this.m_classCache;
        synchronized (map) {
            this.m_classCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        Bundle bundle;
        Class c = PRIMITIVE_TYPES.get(className);
        if (c != null) {
            return c;
        }
        int arrayDim = 0;
        while (className.startsWith("[")) {
            className = className.substring(1);
            ++arrayDim;
        }
        if (className.matches("L.*;")) {
            className = className.substring(1, className.length() - 1);
        }
        if (arrayDim > 0) {
            c = this.loadClass(className);
            int[] dimensions = new int[arrayDim];
            c = Array.newInstance(c, dimensions).getClass();
            return c;
        }
        if (className.startsWith("java.")) {
            return this.getParent().loadClass(className);
        }
        Map<String, Class<?>> dimensions = this.m_classCache;
        synchronized (dimensions) {
            c = this.m_classCache.get(className);
            if (c != null) {
                return c;
            }
            if (this.m_classCache.containsKey(className)) {
                throw new ClassNotFoundException(className);
            }
        }
        HashSet<Bundle> usedBundles = new HashSet<Bundle>();
        Bundle[] bundleArray = this.m_bundlesSortedByBundleSymbolicNameLenght;
        int n = this.m_bundlesSortedByBundleSymbolicNameLenght.length;
        int n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (!usedBundles.contains(bundle) && className.startsWith(String.valueOf(bundle.getSymbolicName()) + ".")) {
                usedBundles.add(bundle);
                try {
                    c = bundle.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        bundleArray = this.m_bundlesSortedByBundleSymbolicNameLenght;
        n = this.m_bundlesSortedByBundleSymbolicNameLenght.length;
        n2 = 0;
        while (n2 < n) {
            bundle = bundleArray[n2];
            if (!usedBundles.contains(bundle) && bundle.getState() == 32) {
                usedBundles.add(bundle);
                try {
                    c = bundle.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        bundleArray = this.m_bundles;
        n = this.m_bundles.length;
        n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (!usedBundles.contains(b)) {
                try {
                    c = b.loadClass(className);
                    return this.putInCache(className, c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        try {
            c = Class.forName(className);
            return this.putInCache(className, c);
        }
        catch (Exception exception) {
            this.putInCache(className);
            throw new ClassNotFoundException(className);
        }
    }

    @Override
    public URL getResource(String name) {
        Bundle[] bundleArray = this.m_bundles;
        int n = this.m_bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            try {
                URL url = b.getResource(name);
                if (url != null) {
                    return url;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            URL u = this.getResource(name);
            if (u != null) {
                return u.openStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> urlList = new Vector<URL>();
        Bundle[] bundleArray = this.m_bundles;
        int n = this.m_bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            try {
                Enumeration en = b.getResources(name);
                if (en != null && en.hasMoreElements()) {
                    while (en.hasMoreElements()) {
                        URL url = (URL)en.nextElement();
                        urlList.add(url);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return urlList.elements();
    }
}

