/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.project.AbstractNlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.project.NlsProjectEvent;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.AbstractTranslationResource;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResource;
import org.eclipse.scout.nls.sdk.simple.internal.NlsSdkSimple;
import org.eclipse.scout.nls.sdk.simple.model.ws.NlsType;
import org.eclipse.scout.nls.sdk.simple.model.ws.translationfile.PlatformTranslationFile;
import org.eclipse.scout.nls.sdk.simple.model.ws.translationfile.WorkspaceTranslationFile;
import org.eclipse.scout.nls.sdk.simple.ui.dialog.language.TranslationFileNewDialog;
import org.eclipse.scout.nls.sdk.simple.ui.dialog.language.TranslationFileNewModel;
import org.eclipse.scout.nls.sdk.ui.action.INewLanguageContext;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;

public class SimpleNlsProject
extends AbstractNlsProject {
    private NlsType m_nlsClass;
    private PropertyChangeListener m_nlsClassPropertyListener = new P_NlsClassPropertyChangeListener();
    private static final Pattern PATTERN = Pattern.compile("^([^_]*)_[0-9]+\\.[0-9]+\\.[0-9]+(\\.[^.]+)?\\.jar$");

    public SimpleNlsProject(NlsType type) {
        super(type.getType());
        this.m_nlsClass = type;
        this.getNlsType().addPropertyChangeListener(this.m_nlsClassPropertyListener);
        this.updateTranslationResourceLocation();
        this.setSuperType(this.m_nlsClass.getSuperType());
    }

    public ITranslationResource[] loadTranslationResources() throws CoreException {
        if (this.getNlsType().getType().isReadOnly()) {
            IPackageFragmentRoot r = (IPackageFragmentRoot)this.getNlsType().getType().getAncestor(3);
            if (r == null) {
                NlsCore.logWarning((String)("Could not find text resource for type '" + this.getNlsType().getType().getFullyQualifiedName() + "'."));
                return new ITranslationResource[0];
            }
            return this.loadTranslationFilesFromPlatform(this.getNlsType(), r);
        }
        return this.loadTranslationFilesWorkspace(this.getNlsType());
    }

    private ITranslationResource[] loadTranslationFilesWorkspace(NlsType nlsType) throws CoreException {
        ArrayList<WorkspaceTranslationFile> translationFiles = new ArrayList<WorkspaceTranslationFile>();
        if (nlsType != null && TypeUtility.exists((IJavaElement)nlsType.getType()) && nlsType.getTranslationsFolderName() != null && nlsType.getTranslationsPrefix() != null) {
            Path translationPath = new Path(nlsType.getTranslationsFolderName());
            for (IFile file : NlsSdkSimple.getAllTranslations(nlsType.getJavaProject().getProject(), (IPath)translationPath, nlsType.getTranslationsPrefix())) {
                translationFiles.add(new WorkspaceTranslationFile(file));
            }
            List<IProject> workspaceFragments = NlsSdkSimple.getWorkspaceFragments(nlsType.getHostPluginId());
            for (IProject fragment : workspaceFragments) {
                for (IFile file : NlsSdkSimple.getAllTranslations(fragment, (IPath)translationPath, nlsType.getTranslationsPrefix())) {
                    translationFiles.add(new WorkspaceTranslationFile(file));
                }
            }
        }
        return translationFiles.toArray(new ITranslationResource[translationFiles.size()]);
    }

    private ITranslationResource[] loadTranslationFilesFromPlatform(NlsType nlsType, IPackageFragmentRoot r) throws CoreException {
        IPackageFragment textFolder;
        String d;
        ArrayList<PlatformTranslationFile> translationFiles = new ArrayList<PlatformTranslationFile>();
        char delim = '.';
        String path = nlsType.getTranslationsFolderName().replace('/', delim);
        if (path.startsWith(d = "" + delim)) {
            path = path.substring(d.length());
        }
        if ((textFolder = r.getPackageFragment(path)) == null) {
            NlsCore.logWarning((String)("Folder '" + nlsType.getTranslationsFolderName() + "' could not be found in '" + r.getElementName() + "'. Will be ignored."));
        } else {
            Object[] objectArray = textFolder.getNonJavaResources();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                block19: {
                    Object o = objectArray[n2];
                    if (o instanceof JarEntryFile) {
                        JarEntryFile f = (JarEntryFile)o;
                        InputStream is = null;
                        try {
                            try {
                                is = f.getContents();
                                translationFiles.add(new PlatformTranslationFile(is, NlsSdkSimple.getLanguage(f.getName())));
                            }
                            catch (Exception e) {
                                NlsCore.logError((String)("Could not load NLS files of bundle '" + r.getElementName() + "'."), (Throwable)e);
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Exception exception) {}
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return (ITranslationResource[])translationFiles.toArray(new AbstractTranslationResource[translationFiles.size()]);
    }

    private void createTranslationFile(Language language, INlsFolder folder, IProgressMonitor monitor) throws CoreException {
        String fileName = NlsSdkSimple.getLocalizedPropertiesFileName(this.getNlsType().getTranslationsPrefix(), language);
        IFile file = folder.getFolder().getFile((IPath)new Path(fileName));
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, monitor);
        }
        this.addTranslationResource((ITranslationResource)new WorkspaceTranslationFile(file), monitor);
    }

    public INewLanguageContext getTranslationCreationContext() {
        return new INewLanguageContext(){
            private final TranslationFileNewModel m_model;
            {
                this.m_model = new TranslationFileNewModel(SimpleNlsProject.this);
            }

            public boolean interactWithUi(Shell s) {
                TranslationFileNewDialog dialog = new TranslationFileNewDialog(s, this.m_model);
                return dialog.open() == 0;
            }

            public void execute(IProgressMonitor monitor) {
                try {
                    SimpleNlsProject.this.createTranslationFile(this.m_model.getLanguage(), this.m_model.getFolder(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    NlsCore.logError((String)"Unable to create new language.", (Throwable)e);
                }
            }

            public Object getModel() {
                return this.m_model;
            }
        };
    }

    private void setSuperType(IType superType) {
        if (superType != null) {
            try {
                this.setParent(NlsCore.getNlsWorkspace().getNlsProject(new Object[]{superType}));
            }
            catch (CoreException e) {
                NlsCore.logError((String)("parent of NLS project could not be found. Looked for type '" + superType.getFullyQualifiedName() + "'"));
            }
        }
    }

    public NlsType getNlsType() {
        return this.m_nlsClass;
    }

    private class P_NlsClassPropertyChangeListener
    implements PropertyChangeListener {
        private P_NlsClassPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("translationFilePrefix".equals(evt.getPropertyName()) || "translationFolderName".equals(evt.getPropertyName())) {
                SimpleNlsProject.this.resetCache();
                SimpleNlsProject.this.updateTranslationResourceLocation();
                SimpleNlsProject.this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)SimpleNlsProject.this, 16));
            } else if ("superType".equals(evt.getPropertyName())) {
                SimpleNlsProject.this.resetCache();
                SimpleNlsProject.this.setSuperType(SimpleNlsProject.this.getNlsType().getSuperType());
                SimpleNlsProject.this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)SimpleNlsProject.this, 16));
            }
        }
    }
}

