/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.AbstractMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.IMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.MobileTablePropertyDelegator;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.columns.AbstractRowSummaryColumn;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableUIFacade;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class MobileTable
extends AbstractMobileTable
implements IMobileTable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MobileTable.class);
    private static final int ROW_HEIGHT = 18;
    private int m_maxCellDetailColumns;
    private OptimisticLock m_selectionLock;
    private MobileTablePropertyDelegator m_propertyDelegator;
    private P_TableEventListener m_tableListener;

    public MobileTable(ITable originalTable) {
        super(false);
        HashSet<String> filter = new HashSet<String>();
        filter.add("autoResizeColumns");
        filter.add("rowHeightHint");
        filter.add("defaultIcon");
        filter.add("headerVisible");
        this.m_propertyDelegator = new MobileTablePropertyDelegator(originalTable, this, (Set<String>)filter);
        this.callInitializer();
        try {
            this.m_selectionLock = new OptimisticLock();
            this.m_tableListener = new P_TableEventListener();
            this.m_tableListener.init();
            this.getOriginalTable().addUITableListener((TableListener)this.m_tableListener);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_propertyDelegator.init();
        this.setAutoDiscardOnDelete(false);
        this.setAutoResizeColumns(true);
        this.setDefaultIconId(null);
        this.setHeaderVisible(false);
        this.m_maxCellDetailColumns = 2;
        if (this.getOriginalTable().getRowHeightHint() == -1) {
            this.setRowHeightHint((this.m_maxCellDetailColumns + 1) * 18);
        }
        this.getContentColumn().setDefaultDrillDownStyle(this.getDefaultDrillDownStyle());
    }

    @Override
    protected boolean execIsAutoCreateTableRowForm() {
        if (this.getOriginalTable().hasProperty("autoCreateTableRowForm")) {
            return MobileTable.isAutoCreateRowForm(this.getOriginalTable());
        }
        return !this.getOriginalTable().isCheckable();
    }

    @Override
    protected String execComputeDefaultDrillDownStyle() {
        if (this.getOriginalTable().hasProperty("defaultDrillDownStyle")) {
            return MobileTable.getDefaultDrillDownStyle(this.getOriginalTable());
        }
        if (this.getOriginalTable().isCheckable()) {
            return "none";
        }
        if (!(this.getOriginalTable() instanceof IMobileTable) && (ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"execRowsSelected", (Class[])new Class[]{ITableRow[].class}, this.getOriginalTable().getClass()) || ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"execRowClick", (Class[])new Class[]{ITableRow.class}, this.getOriginalTable().getClass()))) {
            return "button";
        }
        return "icon";
    }

    private void updatePageIndex() {
        if (this.getPageIndex() >= this.getPageCount()) {
            MobileTable.setPageIndex(this.getOriginalTable(), this.getPageCount() - 1);
        }
    }

    public void dispose() {
        if (this.m_tableListener == null) {
            return;
        }
        this.getOriginalTable().removeTableListener((TableListener)this.m_tableListener);
        this.m_tableListener = null;
    }

    public ITable getOriginalTable() {
        return (ITable)this.m_propertyDelegator.getSender();
    }

    @Override
    public String getDrillDownStyle(ITableRow tableRow) {
        String drillDownStyle = super.getDrillDownStyle(tableRow);
        if (drillDownStyle == null) {
            drillDownStyle = this.getContentColumn().getDefaultDrillDownStyle();
        }
        return drillDownStyle;
    }

    protected void execRowsSelected(ITableRow[] rows) throws ProcessingException {
        try {
            if (!this.m_selectionLock.acquire()) {
                return;
            }
            this.getOriginalTable().getUIFacade().setSelectedRowsFromUI((ITableRow[])this.getRowMapColumn().getValues(rows));
            ITableRow originalRow = null;
            if (rows != null && rows.length > 0) {
                originalRow = (ITableRow)this.getRowMapColumn().getValue(rows[0]);
            }
            if (originalRow != null && this.isAutoCreateTableRowForm() && "icon".equals(this.getDrillDownStyle(originalRow))) {
                this.startTableRowForm(originalRow);
            }
        }
        finally {
            this.m_selectionLock.release();
        }
    }

    protected void execRowClick(ITableRow row) throws ProcessingException {
        ITableRow originalRow = (ITableRow)this.getRowMapColumn().getValue(row);
        this.getOriginalTable().getUIFacade().fireRowClickFromUI(originalRow);
    }

    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
        ITableRow originalRow = (ITableRow)this.getRowMapColumn().getValue(this.getSelectedRow());
        this.getOriginalTable().getUIFacade().fireHyperlinkActionFromUI(originalRow, null, url);
        if (AbstractRowSummaryColumn.isDrillDownButtonUrl(url, path, local)) {
            this.execDrillDownButtonAction();
        }
    }

    protected void execDrillDownButtonAction() throws ProcessingException {
        if (this.isAutoCreateTableRowForm()) {
            ITableRow originalRow = null;
            ITableRow selectedRow = this.getSelectedRow();
            if (selectedRow != null) {
                originalRow = (ITableRow)this.getRowMapColumn().getValue(selectedRow);
            }
            this.startTableRowForm(originalRow);
        }
    }

    public ContentColumn getContentColumn() {
        return (ContentColumn)this.getColumnSet().getColumnByClass(ContentColumn.class);
    }

    public RowMapColumn getRowMapColumn() {
        return (RowMapColumn)this.getColumnSet().getColumnByClass(RowMapColumn.class);
    }

    @Override
    protected ITableUIFacade createUIFacade() {
        return new P_DispatchingMobileTableUIFacade();
    }

    private void reset() {
        this.discardAllRows();
    }

    private void handleWrappedTableRowsDeleted(ITableRow[] rows) {
        try {
            this.setTableChanging(true);
            ITableRow[] iTableRowArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                ITableRow deletedRow = iTableRowArray[n2];
                ITableRow mobileTableRow = this.getRowMapColumn().findRow(deletedRow);
                this.discardRow(mobileTableRow);
                ++n2;
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void handleWrappedTableRowsSelected(ITableRow[] rows) {
        try {
            this.setTableChanging(true);
            ITableRow[] mappedRows = this.getRowMapColumn().findRows(rows);
            this.selectRows(mappedRows);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void handleWrappedTableRowsInserted(ITableRow[] rows) {
        try {
            this.setTableChanging(true);
            this.insertWrappedTableRows(rows);
            this.updatePageIndex();
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void insertWrappedTableRows(ITableRow[] rows) {
        if (!this.getContentColumn().isInitialized()) {
            this.getContentColumn().initializeDecorationConfiguration(this.getOriginalTable(), this.m_maxCellDetailColumns);
        }
        ITableRow[] iTableRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            ITableRow insertedRow = iTableRowArray[n2];
            if (insertedRow.isFilterAccepted()) {
                try {
                    ITableRow row = this.addRowByArray(new Object[]{insertedRow, "", ""});
                    this.getContentColumn().updateValue(row, insertedRow, this.getDrillDownStyleMap());
                }
                catch (ProcessingException exception) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(exception);
                }
            }
            ++n2;
        }
    }

    private void handleWrappedTableRowOrderChanged(ITableRow[] rows) {
        ITableRow[] sortedMobileRows = this.getRowMapColumn().findRows(rows);
        this.sort(sortedMobileRows);
    }

    private void handleWrappedTableRowsUpdated(ITableRow[] originalRows) {
        if (this.getOriginalTable() == null || this.getOriginalTable().getRowCount() == 0) {
            return;
        }
        try {
            this.setTableChanging(true);
            try {
                ITableRow[] iTableRowArray = originalRows;
                int n = originalRows.length;
                int n2 = 0;
                while (n2 < n) {
                    ITableRow originalRow = iTableRowArray[n2];
                    ITableRow row = this.getRowMapColumn().findRow(originalRow);
                    if (row != null) {
                        this.getContentColumn().updateValue(row, originalRow, this.getDrillDownStyleMap());
                        if (this.isCheckable()) {
                            this.checkRow(row, originalRow.isChecked());
                        }
                    }
                    ++n2;
                }
            }
            catch (ProcessingException exception) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(exception);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void syncSelectedRows() {
        if (this.getOriginalTable().getSelectedRowCount() == 0) {
            return;
        }
        this.selectRows(this.getRowMapColumn().findRows(this.getOriginalTable().getSelectedRows()));
    }

    private void syncCheckedRows() throws ProcessingException {
        if (!this.isCheckable() || this.getOriginalTable().getCheckedRows().length == 0) {
            return;
        }
        this.checkRows(this.getRowMapColumn().findRows(this.getOriginalTable().getCheckedRows()), true);
    }

    private void syncTableRows() {
        if (this.getOriginalTable().getRowCount() == 0) {
            return;
        }
        this.insertWrappedTableRows(this.getOriginalTable().getRows());
    }

    @Order(value=20.0)
    public class ContentColumn
    extends AbstractRowSummaryColumn {
    }

    protected class P_DispatchingMobileTableUIFacade
    extends AbstractMobileTable.P_MobileTableUIFacade {
        protected P_DispatchingMobileTableUIFacade() {
            super(MobileTable.this);
        }

        public IMenu[] fireRowPopupFromUI() {
            return MobileTable.this.getOriginalTable().getUIFacade().fireRowPopupFromUI();
        }

        public IMenu[] fireEmptySpacePopupFromUI() {
            return MobileTable.this.getOriginalTable().getUIFacade().fireEmptySpacePopupFromUI();
        }

        public IMenu[] fireHeaderPopupFromUI() {
            return MobileTable.this.getOriginalTable().getUIFacade().fireHeaderPopupFromUI();
        }

        public TransferObject fireRowsDragRequestFromUI() {
            return MobileTable.this.getOriginalTable().getUIFacade().fireRowsDragRequestFromUI();
        }

        public void fireRowDropActionFromUI(ITableRow row, TransferObject dropData) {
            MobileTable.this.getOriginalTable().getUIFacade().fireRowDropActionFromUI((ITableRow)MobileTable.this.getRowMapColumn().getValue(row), dropData);
        }

        public boolean fireKeyTypedFromUI(String keyStrokeText, char keyChar) {
            return MobileTable.this.getOriginalTable().getUIFacade().fireKeyTypedFromUI(keyStrokeText, keyChar);
        }

        @Override
        public void setPageIndexFromUi(int pageIndex) {
            MobileTable.this.getOriginalTable().setProperty("pageIndex", (Object)pageIndex);
        }

        public void fireRowActionFromUI(ITableRow row) {
        }

        public void fireColumnMovedFromUI(IColumn<?> c, int toViewIndex) {
        }

        public void fireVisibleColumnsChangedFromUI(IColumn<?>[] visibleColumns) {
        }

        public void setColumnWidthFromUI(IColumn<?> c, int newWidth) {
        }

        public IFormField prepareCellEditFromUI(ITableRow row, IColumn<?> col) {
            return null;
        }

        public void completeCellEditFromUI() {
        }

        public void cancelCellEditFromUI() {
        }
    }

    private class P_TableEventListener
    extends TableAdapter {
        private P_TableEventListener() {
        }

        protected void init() throws ProcessingException {
            try {
                MobileTable.this.setTableChanging(true);
                MobileTable.this.syncTableRows();
                MobileTable.this.syncSelectedRows();
                MobileTable.this.syncCheckedRows();
            }
            finally {
                MobileTable.this.setTableChanging(false);
            }
        }

        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 103: {
                    MobileTable.this.handleWrappedTableRowsSelected(e.getRows());
                    break;
                }
                case 105: {
                    MobileTable.this.reset();
                    break;
                }
                case 102: {
                    MobileTable.this.handleWrappedTableRowsDeleted(e.getRows());
                    break;
                }
                case 100: {
                    MobileTable.this.handleWrappedTableRowsInserted(e.getRows());
                    break;
                }
                case 101: {
                    MobileTable.this.handleWrappedTableRowsUpdated(e.getRows());
                    break;
                }
                case 200: {
                    MobileTable.this.handleWrappedTableRowOrderChanged(e.getRows());
                }
            }
        }
    }

    @Order(value=10.0)
    public class RowMapColumn
    extends AbstractColumn<ITableRow> {
        protected boolean getConfiguredDisplayable() {
            return false;
        }
    }
}

