/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.BigDecimalColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.BooleanColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.DateColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.DoubleColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.IntegerColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.LongColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.SmartColumnField;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields.StringColumnField;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class ColumnFieldBuilder {
    public Map<IColumn<?>, IFormField> build(IColumn<?>[] columns, ITableRow row) throws ProcessingException {
        HashMap fields = new HashMap();
        if (columns == null) {
            return fields;
        }
        IColumn<?>[] iColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn<?> column = iColumnArray[n2];
            IFormField field = this.createValueField(column, row);
            if (field != null) {
                fields.put(column, field);
            }
            ++n2;
        }
        return fields;
    }

    protected IFormField createValueField(IColumn<?> column, ITableRow row) throws ProcessingException {
        IFormField field;
        if (column.isEditable() && (field = this.createEditableField(column, row)) != null) {
            return field;
        }
        if (column instanceof IStringColumn) {
            return new StringColumnField((IStringColumn)column);
        }
        if (column instanceof ISmartColumn) {
            return new SmartColumnField((ISmartColumn)column);
        }
        if (column instanceof IDoubleColumn) {
            return new DoubleColumnField((IDoubleColumn)column);
        }
        if (column instanceof IDateColumn) {
            return new DateColumnField((IDateColumn)column);
        }
        if (column instanceof IBooleanColumn) {
            return new BooleanColumnField((IBooleanColumn)column);
        }
        if (column instanceof ILongColumn) {
            return new LongColumnField((ILongColumn)column);
        }
        if (column instanceof IIntegerColumn) {
            return new IntegerColumnField((IIntegerColumn)column);
        }
        if (column instanceof IBigDecimalColumn) {
            return new BigDecimalColumnField((IBigDecimalColumn)column);
        }
        return null;
    }

    protected IFormField createEditableField(IColumn<?> column, ITableRow row) throws ProcessingException {
        IFormField field = column.prepareEdit(row);
        if (field != null) {
            field.setLabelVisible(true);
            GridData gd = field.getGridDataHints();
            gd.weightY = 0.0;
            field.setGridDataHints(gd);
            field.setLabel(column.getHeaderCell().getText());
            field.setTooltipText(column.getHeaderCell().getTooltipText());
        }
        return field;
    }
}

