/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleClassDescriptor;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.servicetunnel.ServiceTunnelUtility;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeChangedNotification;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;

@Priority(value=-3.0f)
public class CodeServiceClientProxy
extends AbstractService
implements ICodeService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(CodeServiceClientProxy.class);
    private final Object m_stateLock = new Object();
    private final HashMap<CompositeObject, ServiceState> m_stateMap = new HashMap();

    private ServiceState getServiceState() {
        return this.getServiceState(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceState getServiceState(Long partitionId) {
        IClientSession session = ClientJob.getCurrentSession();
        if (session == null) {
            LOG.warn("could not find a client session");
            return null;
        }
        if (partitionId == null && session.getSharedVariableMap().containsKey("partitionId")) {
            partitionId = (Long)session.getSharedVariableMap().get("partitionId");
        }
        CompositeObject key = new CompositeObject(new Object[]{session.getClass(), LocaleThreadLocal.get(), partitionId});
        Object object = this.m_stateLock;
        synchronized (object) {
            ServiceState data = this.m_stateMap.get(key);
            if (data == null) {
                data = new ServiceState();
                this.m_stateMap.put(key, data);
            }
            return data;
        }
    }

    public void initializeService() {
        super.initializeService();
        ((IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class)).addGlobalClientNotificationConsumerListener(new IClientNotificationConsumerListener(){

            @Override
            public void handleEvent(final ClientNotificationConsumerEvent e, boolean sync) {
                if (e.getClientNotification().getClass() == CodeTypeChangedNotification.class) {
                    if (sync) {
                        try {
                            CodeServiceClientProxy.this.reloadCodeTypes(((CodeTypeChangedNotification)e.getClientNotification()).getCodeTypes());
                        }
                        catch (Throwable t) {
                            LOG.error("update due to client notification", t);
                        }
                    } else {
                        new ClientSyncJob("Reload code types", ClientSyncJob.getCurrentSession()){

                            @Override
                            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                                CodeServiceClientProxy.this.reloadCodeTypes(((CodeTypeChangedNotification)e.getClientNotification()).getCodeTypes());
                            }
                        }.schedule();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType> T getCodeType(Class<T> type) {
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            ICodeType instance = state.m_cache.get(type);
            if (instance == null && (instance = this.getRemoteService().getCodeType(type)) != null) {
                state.m_cache.put(type, instance);
            }
            return (T)instance;
        }
    }

    public <T extends ICodeType> T getCodeType(Long partitionId, Class<T> type) {
        ICodeType instance = this.getRemoteService().getCodeType(partitionId, type);
        return (T)instance;
    }

    public ICodeType findCodeTypeById(Object id) {
        if (id == null) {
            return null;
        }
        ICodeType ct = this.findCodeTypeByIdInternal(id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.findCodeTypeByIdInternal(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICodeType findCodeTypeByIdInternal(Object id) {
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            for (ICodeType ct : state.m_cache.values()) {
                if (!id.equals(ct.getId())) continue;
                return ct;
            }
        }
        return null;
    }

    public ICodeType findCodeTypeById(Long partitionId, Object id) {
        if (id == null) {
            return null;
        }
        ICodeType ct = this.findCodeTypeByIdInternal(partitionId, id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes("");
        return this.findCodeTypeByIdInternal(partitionId, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICodeType findCodeTypeByIdInternal(Long partitionId, Object id) {
        ServiceState state = this.getServiceState(partitionId);
        Object object = state.m_cacheLock;
        synchronized (object) {
            for (ICodeType ct : state.m_cache.values()) {
                if (!id.equals(ct.getId())) continue;
                return ct;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType[] getCodeTypes(Class ... types) {
        ArrayList<Class> missingTypes = new ArrayList<Class>();
        ICodeType[] instances = new ICodeType[types.length];
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            int i = 0;
            while (i < types.length) {
                instances[i] = state.m_cache.get(types[i]);
                if (instances[i] == null) {
                    missingTypes.add(types[i]);
                }
                ++i;
            }
        }
        if (missingTypes.size() > 0) {
            ICodeType[] newInstances = this.getRemoteService().getCodeTypes(missingTypes.toArray(new Class[0]));
            Object object2 = state.m_cacheLock;
            synchronized (object2) {
                int k = 0;
                int i = 0;
                while (i < types.length) {
                    if (instances[i] == null) {
                        instances[i] = newInstances[k];
                        if (instances[i] != null) {
                            state.m_cache.put(types[i], instances[i]);
                        }
                        ++k;
                    }
                    ++i;
                }
            }
        }
        return instances;
    }

    public ICodeType[] getCodeTypes(Long partitionId, Class ... types) {
        ICodeType[] codeTypes = this.getRemoteService().getCodeTypes(partitionId, types);
        return codeTypes;
    }

    private <T extends ICode> Class getDeclaringCodeTypeClass(Class<T> type) {
        if (type == null) {
            return null;
        }
        Class<?> declaringCodeTypeClass = null;
        if (type.getDeclaringClass() != null) {
            Class<?> c = type.getDeclaringClass();
            while (c != null && !ICodeType.class.isAssignableFrom(c)) {
                c = c.getDeclaringClass();
            }
            declaringCodeTypeClass = c;
        }
        if (declaringCodeTypeClass == null) {
            try {
                declaringCodeTypeClass = ((ICode)type.newInstance()).getCodeType().getClass();
            }
            catch (Throwable t) {
                LOG.error("find code " + type, t);
            }
        }
        return declaringCodeTypeClass;
    }

    private <T> T findCode(final Class<T> type, ICodeType codeType) {
        final Holder codeHolder = new Holder(ICode.class);
        ICodeVisitor v = new ICodeVisitor(){

            public boolean visit(ICode code, int treeLevel) {
                if (code.getClass() == type) {
                    codeHolder.setValue((Object)code);
                    return false;
                }
                return true;
            }
        };
        codeType.visit(v);
        return (T)codeHolder.getValue();
    }

    public <T extends ICode> T getCode(Class<T> type) {
        Class declaringCodeTypeClass = this.getDeclaringCodeTypeClass(type);
        T codeType = this.getCodeType(declaringCodeTypeClass);
        return (T)((ICode)this.findCode(type, (ICodeType)codeType));
    }

    public <T extends ICode> T getCode(Long partitionId, Class<T> type) {
        Class declaringCodeTypeClass = this.getDeclaringCodeTypeClass(type);
        T codeType = this.getCodeType(partitionId, declaringCodeTypeClass);
        return (T)((ICode)this.findCode(type, (ICodeType)codeType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ICodeType> T reloadCodeType(Class<T> type) {
        this.unloadCodeType(type);
        ICodeType instance = this.getRemoteService().getCodeType(type);
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            if (instance != null) {
                state.m_cache.put(type, instance);
            }
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeType[] reloadCodeTypes(Class ... types) {
        int i = 0;
        while (i < types.length) {
            this.unloadCodeType(types[i]);
            ++i;
        }
        ICodeType[] instances = this.getRemoteService().getCodeTypes(types);
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            int i2 = 0;
            while (i2 < types.length) {
                if (instances[i2] != null) {
                    state.m_cache.put(types[i2], instances[i2]);
                }
                ++i2;
            }
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleClassDescriptor[] getAllCodeTypeClasses(String classPrefix) {
        if (classPrefix == null) {
            return new BundleClassDescriptor[0];
        }
        ServiceState state = this.getServiceState();
        Object object = state.m_codeTypeClassDescriptorMapLock;
        synchronized (object) {
            BundleClassDescriptor[] remoteCodeTypes;
            BundleClassDescriptor[] a = state.m_codeTypeClassDescriptorMap.get(classPrefix);
            if (a != null) {
                return a;
            }
            HashSet<BundleClassDescriptor> verifiedCodeTypes = new HashSet<BundleClassDescriptor>();
            BundleClassDescriptor[] bundleClassDescriptorArray = remoteCodeTypes = this.getRemoteService().getAllCodeTypeClasses(classPrefix);
            int n = remoteCodeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                BundleClassDescriptor d = bundleClassDescriptorArray[n2];
                try {
                    Platform.getBundle((String)d.getBundleSymbolicName()).loadClass(d.getClassName());
                    verifiedCodeTypes.add(d);
                }
                catch (Throwable t) {
                    LOG.error("Missing code-type in client: " + d.getClassName() + ", defined in server-side bundle " + d.getBundleSymbolicName());
                }
                ++n2;
            }
            a = verifiedCodeTypes.toArray(new BundleClassDescriptor[verifiedCodeTypes.size()]);
            state.m_codeTypeClassDescriptorMap.put(classPrefix, a);
            return a;
        }
    }

    public ICodeType[] getAllCodeTypes(String classPrefix) {
        ArrayList<Class> list = new ArrayList<Class>();
        BundleClassDescriptor[] bundleClassDescriptorArray = this.getAllCodeTypeClasses(classPrefix);
        int n = bundleClassDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleClassDescriptor d = bundleClassDescriptorArray[n2];
            try {
                list.add(Platform.getBundle((String)d.getBundleSymbolicName()).loadClass(d.getClassName()));
            }
            catch (Throwable t) {
                LOG.warn("Loading " + d.getClassName() + " of bundle " + d.getBundleSymbolicName(), t);
            }
            ++n2;
        }
        return this.getCodeTypes(list.toArray(new Class[list.size()]));
    }

    public ICodeType[] getAllCodeTypes(String classPrefix, Long partitionId) {
        return this.getAllCodeTypes(classPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ICodeType> void unloadCodeType(Class<T> type) {
        ServiceState state = this.getServiceState();
        Object object = state.m_cacheLock;
        synchronized (object) {
            state.m_cache.remove(type);
        }
    }

    private ICodeService getRemoteService() {
        return ServiceTunnelUtility.createProxy(ICodeService.class, ClientSyncJob.getCurrentSession().getServiceTunnel());
    }

    private static class ServiceState {
        final Object m_cacheLock = new Object();
        final HashMap<Class<? extends ICodeType>, ICodeType> m_cache = new HashMap();
        final Object m_codeTypeClassDescriptorMapLock = new Object();
        final HashMap<String, BundleClassDescriptor[]> m_codeTypeClassDescriptorMap = new HashMap();

        private ServiceState() {
        }
    }
}

