/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.exceptionhandler.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.ErrorHandler;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-1.0f)
public class InternalClientExceptionHandlerService
extends AbstractService
implements IExceptionHandlerService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(InternalClientExceptionHandlerService.class);
    private static final String SESSION_DATA_KEY = "clientExceptionHandlerServiceState";

    private ServiceState getServiceState() {
        IClientSession session = ClientJob.getCurrentSession();
        if (session == null) {
            throw new IllegalStateException("null client session in current job context");
        }
        ServiceState data = (ServiceState)session.getData(SESSION_DATA_KEY);
        if (data == null) {
            data = new ServiceState();
            session.setData(SESSION_DATA_KEY, data);
        }
        return data;
    }

    public void handleException(ProcessingException pe) {
        if (pe.isInterruption()) {
            return;
        }
        ServiceState state = this.getServiceState();
        try {
            if (state.m_handlerLock.acquire()) {
                if (!pe.isConsumed()) {
                    IDesktop desktop;
                    if (Platform.inDevelopmentMode() || !(pe instanceof VetoException)) {
                        IProcessingStatus s = pe.getStatus();
                        boolean logThrowable = !(pe instanceof VetoException);
                        int logLevel = 1;
                        String logText = String.valueOf(((Object)((Object)pe)).getClass().getSimpleName()) + ": " + s.toString();
                        switch (s.getSeverity()) {
                            case 1: {
                                logLevel = 3;
                                break;
                            }
                            case 2: {
                                logLevel = 2;
                                break;
                            }
                            case 4: {
                                logLevel = 1;
                                break;
                            }
                            case 16: {
                                logLevel = 1;
                            }
                        }
                        this.differentiatedLog(InternalClientExceptionHandlerService.class.getName(), logLevel, logText, logThrowable ? pe : null);
                    }
                    if ((desktop = ClientSyncJob.getCurrentSession().getDesktop()) != null && desktop.isOpened()) {
                        this.showExceptionInUI(pe);
                    }
                }
            } else {
                LOG.error("loop detection in " + ((Object)((Object)this)).getClass().getSimpleName() + " when handling: " + (Object)((Object)pe) + ". StackTrace is following", (Throwable)new Exception());
            }
        }
        finally {
            state.m_handlerLock.release();
            pe.consume();
        }
    }

    void differentiatedLog(String fqcn, int level, String m, Throwable t) {
        switch (level) {
            case 5: {
                LOG.trace(m, t);
                break;
            }
            case 4: {
                LOG.debug(m, t);
                break;
            }
            case 3: {
                LOG.info(m, t);
                break;
            }
            case 2: {
                LOG.warn(m, t);
                break;
            }
            case 1: {
                LOG.error(m, t);
            }
        }
    }

    protected void showExceptionInUI(ProcessingException pe) {
        new ErrorHandler(pe).showMessageBox();
    }

    private static class ServiceState {
        final OptimisticLock m_handlerLock = new OptimisticLock();

        private ServiceState() {
        }
    }
}

