/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.services.common.progress.ISimpleProgress;
import org.eclipse.scout.rt.client.services.common.progress.ISimpleProgressService;
import org.eclipse.scout.rt.client.test.FormBasedTestContext;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractLongColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCloseButton;
import org.eclipse.scout.rt.client.ui.form.fields.checkbox.AbstractCheckBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.services.common.test.ITest;
import org.eclipse.scout.rt.shared.services.common.test.ITestContext;
import org.eclipse.scout.rt.shared.services.common.test.TestUtility;
import org.eclipse.scout.service.SERVICES;

@FormData
@Deprecated
public class DefaultClientTestForm
extends AbstractForm {
    @Override
    protected String getConfiguredTitle() {
        return "Auto-Test";
    }

    @Override
    protected boolean getConfiguredModal() {
        return false;
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.TestGroupBox getTestGroupBox() {
        return this.getFieldByClass(MainBox.TestGroupBox.class);
    }

    public MainBox.SettingsGroupBox getSettingsGroupBox() {
        return this.getFieldByClass(MainBox.SettingsGroupBox.class);
    }

    public MainBox.StatsGroupBox getStatsGroupBox() {
        return this.getFieldByClass(MainBox.StatsGroupBox.class);
    }

    public MainBox.SettingsGroupBox.Level1Box getLevel1Box() {
        return this.getFieldByClass(MainBox.SettingsGroupBox.Level1Box.class);
    }

    public MainBox.SettingsGroupBox.Level2Box getLevel2Box() {
        return this.getFieldByClass(MainBox.SettingsGroupBox.Level2Box.class);
    }

    public MainBox.SettingsGroupBox.Level3Box getLevel3Box() {
        return this.getFieldByClass(MainBox.SettingsGroupBox.Level3Box.class);
    }

    public MainBox.StatsGroupBox.SuccessfulTestsField getSuccessfulTestsField() {
        return this.getFieldByClass(MainBox.StatsGroupBox.SuccessfulTestsField.class);
    }

    public MainBox.StatsGroupBox.FailedTestsField getFailedTestsField() {
        return this.getFieldByClass(MainBox.StatsGroupBox.FailedTestsField.class);
    }

    public MainBox.StatsGroupBox.TotalTestsField getTotalTestsField() {
        return this.getFieldByClass(MainBox.StatsGroupBox.TotalTestsField.class);
    }

    public MainBox.StatsGroupBox.WarningTestsField getWarningTestsField() {
        return this.getFieldByClass(MainBox.StatsGroupBox.WarningTestsField.class);
    }

    public MainBox.ResultsGroupBox getResultsGroupBox() {
        return this.getFieldByClass(MainBox.ResultsGroupBox.class);
    }

    public MainBox.ResultsGroupBox.ResultsTableField getResultsTableField() {
        return this.getFieldByClass(MainBox.ResultsGroupBox.ResultsTableField.class);
    }

    public MainBox.TestGroupBox.TestsTableField getTestsTableField() {
        return this.getFieldByClass(MainBox.TestGroupBox.TestsTableField.class);
    }

    public MainBox.CloseButton getCloseButton() {
        return this.getFieldByClass(MainBox.CloseButton.class);
    }

    public MainBox.ResetButton getResetButton() {
        return this.getFieldByClass(MainBox.ResetButton.class);
    }

    public MainBox.TestButton getTestButton() {
        return this.getFieldByClass(MainBox.TestButton.class);
    }

    public void runTests(ITest[] tests) {
        ISimpleProgressService pgSvc = (ISimpleProgressService)SERVICES.getService(ISimpleProgressService.class);
        ISimpleProgress pg = pgSvc.addProgress("Test...");
        try {
            FormBasedTestContext ctx = new FormBasedTestContext(this);
            TestUtility.runTests((ITestContext)ctx, (ITest[])tests);
        }
        finally {
            pgSvc.removeProgress(pg);
        }
    }

    public void exportTestResults() throws ProcessingException {
    }

    public void startNew() throws ProcessingException {
        this.startInternal(new NewHandler());
    }

    @Override
    protected boolean getConfiguredMaximizeEnabled() {
        return true;
    }

    @Order(value=20.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 2;
        }

        @Order(value=40.0)
        public class CloseButton
        extends AbstractCloseButton {
            @Override
            protected String getConfiguredLabel() {
                return "Close";
            }
        }

        @Order(value=60.0)
        public class ExportButton
        extends AbstractButton {
            @Override
            protected String getConfiguredLabel() {
                return "Export to Excel";
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                DefaultClientTestForm.this.exportTestResults();
            }
        }

        @Order(value=55.0)
        public class ResetButton
        extends AbstractButton {
            @Override
            protected String getConfiguredLabel() {
                return "Reset Results";
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                ((ResultsGroupBox.ResultsTableField.Table)DefaultClientTestForm.this.getResultsTableField().getTable()).discardAllRows();
                DefaultClientTestForm.this.getTotalTestsField().setValue(null);
                DefaultClientTestForm.this.getFailedTestsField().setValue(null);
                DefaultClientTestForm.this.getWarningTestsField().setValue(null);
                DefaultClientTestForm.this.getSuccessfulTestsField().setValue(null);
            }
        }

        @Order(value=30.0)
        public class ResultsGroupBox
        extends AbstractGroupBox {
            @Override
            protected int getConfiguredGridW() {
                return 2;
            }

            @Override
            protected int getConfiguredGridColumnCount() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return "Results";
            }

            @Override
            protected boolean getConfiguredLabelVisible() {
                return false;
            }

            @Order(value=10.0)
            public class ResultsTableField
            extends AbstractTableField<Table> {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 10;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Order(value=10.0)
                public class Table
                extends AbstractTable {
                    @Override
                    protected boolean getConfiguredAutoResizeColumns() {
                        return true;
                    }

                    public ProductColumn getProductColumn() {
                        return this.getColumnSet().getColumnByClass(ProductColumn.class);
                    }

                    public SubTitleColumn getSubTitleColumn() {
                        return this.getColumnSet().getColumnByClass(SubTitleColumn.class);
                    }

                    public TitleColumn getTitleColumn() {
                        return this.getColumnSet().getColumnByClass(TitleColumn.class);
                    }

                    public ResultColumn getResultColumn() {
                        return this.getColumnSet().getColumnByClass(ResultColumn.class);
                    }

                    public DurationColumn getDurationColumn() {
                        return this.getColumnSet().getColumnByClass(DurationColumn.class);
                    }

                    @Override
                    protected void execInitTable() throws ProcessingException {
                    }

                    @Order(value=100.0)
                    public class DurationColumn
                    extends AbstractLongColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 40;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "Duration [ms]";
                        }
                    }

                    @Order(value=10.0)
                    public class ProductColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 80;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "Product";
                        }
                    }

                    @Order(value=50.0)
                    public class ResultColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 80;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "Result";
                        }
                    }

                    @Order(value=30.0)
                    public class SubTitleColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 120;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "SubTitle";
                        }
                    }

                    @Order(value=20.0)
                    public class TitleColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 170;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "Title";
                        }
                    }
                }
            }
        }

        @Order(value=20.0)
        public class SettingsGroupBox
        extends AbstractGroupBox {
            @Override
            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            @Override
            protected int getConfiguredGridW() {
                return 1;
            }

            @Override
            protected String getConfiguredLabel() {
                return "Settings";
            }

            @Order(value=10.0)
            public class Level1Box
            extends AbstractCheckBox {
                @Override
                protected String getConfiguredLabel() {
                    return "OK";
                }
            }

            @Order(value=20.0)
            public class Level2Box
            extends AbstractCheckBox {
                @Override
                protected String getConfiguredLabel() {
                    return "WARNING";
                }
            }

            @Order(value=30.0)
            public class Level3Box
            extends AbstractCheckBox {
                @Override
                protected String getConfiguredLabel() {
                    return "ERROR";
                }
            }
        }

        @Order(value=25.0)
        public class StatsGroupBox
        extends AbstractGroupBox {
            @Override
            protected int getConfiguredGridColumnCount() {
                return 1;
            }

            @Override
            protected int getConfiguredGridW() {
                return 1;
            }

            @Override
            protected String getConfiguredLabel() {
                return "Statistics";
            }

            @Order(value=30.0)
            public class FailedTestsField
            extends AbstractLongField {
                @Override
                protected String getConfiguredLabel() {
                    return "Failed Tests";
                }

                @Override
                protected boolean getConfiguredEnabled() {
                    return false;
                }
            }

            @Order(value=10.0)
            public class SuccessfulTestsField
            extends AbstractLongField {
                @Override
                protected String getConfiguredLabel() {
                    return "Successful Tests";
                }

                @Override
                protected boolean getConfiguredEnabled() {
                    return false;
                }
            }

            @Order(value=40.0)
            public class TotalTestsField
            extends AbstractLongField {
                @Override
                protected String getConfiguredLabel() {
                    return "Total Tests";
                }

                @Override
                protected boolean getConfiguredEnabled() {
                    return false;
                }
            }

            @Order(value=20.0)
            public class WarningTestsField
            extends AbstractLongField {
                @Override
                protected String getConfiguredLabel() {
                    return "Tests with Warnings";
                }

                @Override
                protected boolean getConfiguredEnabled() {
                    return false;
                }
            }
        }

        @Order(value=50.0)
        public class TestButton
        extends AbstractButton {
            @Override
            protected String getConfiguredLabel() {
                return "Run Selected Tests";
            }

            @Override
            protected void execClickAction() throws ProcessingException {
                HashSet<String> selectedNames = new HashSet<String>();
                selectedNames.addAll(Arrays.asList((String[])((TestGroupBox.TestsTableField.Table)DefaultClientTestForm.this.getTestsTableField().getTable()).getClazzColumn().getSelectedValues()));
                ArrayList<ITest> tests = new ArrayList<ITest>();
                ITest[] iTestArray = (ITest[])SERVICES.getServices(ITest.class);
                int n = iTestArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITest t = iTestArray[n2];
                    if (selectedNames.contains(t.getClass().getSimpleName())) {
                        tests.add(t);
                    }
                    ++n2;
                }
                DefaultClientTestForm.this.runTests(tests.toArray(new ITest[tests.size()]));
            }
        }

        @Order(value=10.0)
        public class TestGroupBox
        extends AbstractGroupBox {
            @Override
            protected int getConfiguredGridW() {
                return 2;
            }

            @Override
            protected int getConfiguredGridColumnCount() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return "Select Tests";
            }

            @Order(value=100.0)
            public class TestsTableField
            extends AbstractTableField<Table> {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 10;
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Order(value=10.0)
                public class Table
                extends AbstractTable {
                    @Override
                    protected boolean getConfiguredAutoResizeColumns() {
                        return true;
                    }

                    public ProductColumn getProductColumn() {
                        return this.getColumnSet().getColumnByClass(ProductColumn.class);
                    }

                    public SubTitleColumn getSubTitleColumn() {
                        return this.getColumnSet().getColumnByClass(SubTitleColumn.class);
                    }

                    public TitleColumn getTitleColumn() {
                        return this.getColumnSet().getColumnByClass(TitleColumn.class);
                    }

                    public ClazzColumn getClazzColumn() {
                        return this.getColumnSet().getColumnByClass(ClazzColumn.class);
                    }

                    @Override
                    protected void execInitTable() throws ProcessingException {
                    }

                    @Order(value=80.0)
                    public class ClazzColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 310;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "Type";
                        }
                    }

                    @Order(value=10.0)
                    public class ProductColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 120;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "Product";
                        }
                    }

                    @Order(value=30.0)
                    public class SubTitleColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 120;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "SubTitle";
                        }
                    }

                    @Order(value=20.0)
                    public class TitleColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 170;
                        }

                        @Override
                        protected String getConfiguredHeaderText() {
                            return "Title";
                        }
                    }
                }
            }
        }
    }

    @Order(value=10.0)
    public class NewHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() throws ProcessingException {
            super.execLoad();
            DefaultClientTestForm.this.getLevel1Box().setValue(true);
            DefaultClientTestForm.this.getLevel2Box().setValue(true);
            DefaultClientTestForm.this.getLevel3Box().setValue(true);
            MainBox.TestGroupBox.TestsTableField.Table table = (MainBox.TestGroupBox.TestsTableField.Table)DefaultClientTestForm.this.getTestsTableField().getTable();
            try {
                table.setTableChanging(true);
                ITest[] iTestArray = (ITest[])SERVICES.getServices(ITest.class);
                int n = iTestArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITest t = iTestArray[n2];
                    ITableRow r = table.createRow();
                    table.getProductColumn().setValue(r, t.getProduct());
                    table.getTitleColumn().setValue(r, t.getTitle());
                    table.getSubTitleColumn().setValue(r, t.getSubTitle());
                    table.getClazzColumn().setValue(r, t.getClass().getSimpleName());
                    table.addRow(r);
                    ++n2;
                }
            }
            finally {
                table.setTableChanging(false);
            }
            ((MainBox.TestGroupBox.TestsTableField.Table)DefaultClientTestForm.this.getTestsTableField().getTable()).selectAllEnabledRows();
        }
    }
}

